/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.CellGlobalIdOrServiceAreaIdOrLAI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.GeodeticInformation;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.GeographicalInformation;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.LocationInformationGPRS;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.RAIdentity;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAIdentity;
import org.restcomm.protocols.ss7.map.primitives.CellGlobalIdOrServiceAreaIdFixedLengthImpl;
import org.restcomm.protocols.ss7.map.primitives.CellGlobalIdOrServiceAreaIdOrLAIImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.LAIFixedLengthImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.GeodeticInformationImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.GeographicalInformationImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.RAIdentityImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.LSAIdentityImpl;

public class LocationInformationGPRSImpl
extends SequenceBase
implements LocationInformationGPRS {
    public static final int _ID_cellGlobalIdOrServiceAreaIdOrLAI = 0;
    private static final int _ID_routeingAreaIdentity = 1;
    private static final int _ID_geographicalInformation = 2;
    private static final int _ID_sgsnNumber = 3;
    private static final int _ID_selectedLSAIdentity = 4;
    private static final int _ID_extensionContainer = 5;
    private static final int _ID_sai_Present = 6;
    private static final int _ID_geodeticInformation = 7;
    private static final int _ID_currentLocationRetrieved = 8;
    private static final int _ID_ageOfLocationInformation = 9;
    private static final String CELL_GLOBAL_ID_OR_SERVICE_AREA_ID_OR_LAI = "cellGlobalIdOrServiceAreaIdOrLAI";
    private static final String ROUTEING_AREA_ID = "routeingAreaIdentity";
    private static final String GEOGRAPHICAL_INFORMATION = "geographicalInformation";
    private static final String SGSN_NUMBER = "sgsnNumber";
    private static final String SELECTED_LSA_ID = "selectedLSAIdentity";
    private static final String EXTENSION_CONTAINER = "extensionContainer";
    private static final String SAI_PRESENT = "saiPresent";
    private static final String GEODETIC_INFORMATION = "geodeticInformation";
    private static final String CURRENT_LOCATION_RETRIEVED = "currentLocationRetrieved";
    private static final String AGE_OF_LOCATION_INFORMATION = "ageOfLocationInformation";
    private CellGlobalIdOrServiceAreaIdOrLAI cellGlobalIdOrServiceAreaIdOrLAI = null;
    private RAIdentity routeingAreaIdentity = null;
    private GeographicalInformation geographicalInformation = null;
    private ISDNAddressString sgsnNumber = null;
    private LSAIdentity selectedLSAIdentity = null;
    private MAPExtensionContainer extensionContainer = null;
    private boolean saiPresent = false;
    private GeodeticInformation geodeticInformation = null;
    private boolean currentLocationRetrieved = false;
    private Integer ageOfLocationInformation = null;
    protected static final XMLFormat<LocationInformationGPRSImpl> LOCATION_INFORMATION_GPRS_XML = new XMLFormat<LocationInformationGPRSImpl>(LocationInformationGPRSImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, LocationInformationGPRSImpl locationInformation) throws XMLStreamException {
            locationInformation.cellGlobalIdOrServiceAreaIdOrLAI = xml.get(LocationInformationGPRSImpl.CELL_GLOBAL_ID_OR_SERVICE_AREA_ID_OR_LAI, CellGlobalIdOrServiceAreaIdOrLAIImpl.class);
            locationInformation.routeingAreaIdentity = xml.get(LocationInformationGPRSImpl.ROUTEING_AREA_ID, RAIdentityImpl.class);
            locationInformation.geographicalInformation = xml.get(LocationInformationGPRSImpl.GEOGRAPHICAL_INFORMATION, GeographicalInformationImpl.class);
            locationInformation.sgsnNumber = xml.get(LocationInformationGPRSImpl.SGSN_NUMBER, ISDNAddressStringImpl.class);
            locationInformation.selectedLSAIdentity = xml.get(LocationInformationGPRSImpl.SELECTED_LSA_ID, LSAIdentityImpl.class);
            locationInformation.extensionContainer = xml.get(LocationInformationGPRSImpl.EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
            Boolean bval = xml.get(LocationInformationGPRSImpl.SAI_PRESENT, Boolean.class);
            if (bval != null) {
                locationInformation.saiPresent = bval;
            }
            locationInformation.geodeticInformation = xml.get(LocationInformationGPRSImpl.GEODETIC_INFORMATION, GeodeticInformationImpl.class);
            bval = xml.get(LocationInformationGPRSImpl.CURRENT_LOCATION_RETRIEVED, Boolean.class);
            if (bval != null) {
                locationInformation.currentLocationRetrieved = bval;
            }
            locationInformation.ageOfLocationInformation = xml.get(LocationInformationGPRSImpl.AGE_OF_LOCATION_INFORMATION, Integer.class);
        }

        @Override
        public void write(LocationInformationGPRSImpl locationInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (locationInformation.cellGlobalIdOrServiceAreaIdOrLAI != null) {
                xml.add((CellGlobalIdOrServiceAreaIdOrLAIImpl)locationInformation.cellGlobalIdOrServiceAreaIdOrLAI, LocationInformationGPRSImpl.CELL_GLOBAL_ID_OR_SERVICE_AREA_ID_OR_LAI, CellGlobalIdOrServiceAreaIdOrLAIImpl.class);
            }
            if (locationInformation.routeingAreaIdentity != null) {
                xml.add((RAIdentityImpl)locationInformation.routeingAreaIdentity, LocationInformationGPRSImpl.ROUTEING_AREA_ID, RAIdentityImpl.class);
            }
            if (locationInformation.geographicalInformation != null) {
                xml.add((GeographicalInformationImpl)locationInformation.geographicalInformation, LocationInformationGPRSImpl.GEOGRAPHICAL_INFORMATION, GeographicalInformationImpl.class);
            }
            if (locationInformation.sgsnNumber != null) {
                xml.add((ISDNAddressStringImpl)locationInformation.sgsnNumber, LocationInformationGPRSImpl.SGSN_NUMBER, ISDNAddressStringImpl.class);
            }
            if (locationInformation.selectedLSAIdentity != null) {
                xml.add((LSAIdentityImpl)locationInformation.selectedLSAIdentity, LocationInformationGPRSImpl.SELECTED_LSA_ID, LSAIdentityImpl.class);
            }
            if (locationInformation.extensionContainer != null) {
                xml.add((MAPExtensionContainerImpl)locationInformation.extensionContainer, LocationInformationGPRSImpl.EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
            }
            if (locationInformation.saiPresent) {
                xml.add(locationInformation.saiPresent, LocationInformationGPRSImpl.SAI_PRESENT, Boolean.class);
            }
            if (locationInformation.geodeticInformation != null) {
                xml.add((GeodeticInformationImpl)locationInformation.geodeticInformation, LocationInformationGPRSImpl.GEODETIC_INFORMATION, GeodeticInformationImpl.class);
            }
            if (locationInformation.currentLocationRetrieved) {
                xml.add(locationInformation.currentLocationRetrieved, LocationInformationGPRSImpl.CURRENT_LOCATION_RETRIEVED, Boolean.class);
            }
            if (locationInformation.ageOfLocationInformation != null) {
                xml.add(locationInformation.ageOfLocationInformation, LocationInformationGPRSImpl.AGE_OF_LOCATION_INFORMATION, Integer.class);
            }
        }
    };

    public LocationInformationGPRSImpl() {
        super("LocationInformationGPRS");
    }

    public LocationInformationGPRSImpl(CellGlobalIdOrServiceAreaIdOrLAI cellGlobalIdOrServiceAreaIdOrLAI, RAIdentity routeingAreaIdentity, GeographicalInformation geographicalInformation, ISDNAddressString sgsnNumber, LSAIdentity selectedLSAIdentity, MAPExtensionContainer extensionContainer, boolean saiPresent, GeodeticInformation geodeticInformation, boolean currentLocationRetrieved, Integer ageOfLocationInformation) {
        super("LocationInformationGPRS");
        this.cellGlobalIdOrServiceAreaIdOrLAI = cellGlobalIdOrServiceAreaIdOrLAI;
        this.routeingAreaIdentity = routeingAreaIdentity;
        this.geographicalInformation = geographicalInformation;
        this.sgsnNumber = sgsnNumber;
        this.selectedLSAIdentity = selectedLSAIdentity;
        this.extensionContainer = extensionContainer;
        this.saiPresent = saiPresent;
        this.geodeticInformation = geodeticInformation;
        this.currentLocationRetrieved = currentLocationRetrieved;
        this.ageOfLocationInformation = ageOfLocationInformation;
    }

    @Override
    public CellGlobalIdOrServiceAreaIdOrLAI getCellGlobalIdOrServiceAreaIdOrLAI() {
        return this.cellGlobalIdOrServiceAreaIdOrLAI;
    }

    @Override
    public RAIdentity getRouteingAreaIdentity() {
        return this.routeingAreaIdentity;
    }

    @Override
    public GeographicalInformation getGeographicalInformation() {
        return this.geographicalInformation;
    }

    @Override
    public ISDNAddressString getSGSNNumber() {
        return this.sgsnNumber;
    }

    @Override
    public LSAIdentity getLSAIdentity() {
        return this.selectedLSAIdentity;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public boolean isSaiPresent() {
        return this.saiPresent;
    }

    @Override
    public GeodeticInformation getGeodeticInformation() {
        return this.geodeticInformation;
    }

    @Override
    public boolean isCurrentLocationRetrieved() {
        return this.currentLocationRetrieved;
    }

    @Override
    public Integer getAgeOfLocationInformation() {
        return this.ageOfLocationInformation;
    }

    public static CellGlobalIdOrServiceAreaIdOrLAI decodeCellGlobalIdOrServiceAreaIdOrLAI(AsnInputStream ais, String primitiveName) throws MAPParsingComponentException, AsnException, IOException {
        if (ais.isTagPrimitive()) {
            int len = ais.readLength();
            if (len == 7) {
                CellGlobalIdOrServiceAreaIdFixedLengthImpl val = new CellGlobalIdOrServiceAreaIdFixedLengthImpl();
                val.decodeData(ais, len);
                CellGlobalIdOrServiceAreaIdOrLAIImpl cellGlobalIdOrServiceAreaIdOrLAI = new CellGlobalIdOrServiceAreaIdOrLAIImpl(val);
                return cellGlobalIdOrServiceAreaIdOrLAI;
            }
            if (len == 5) {
                LAIFixedLengthImpl val = new LAIFixedLengthImpl();
                val.decodeData(ais, len);
                CellGlobalIdOrServiceAreaIdOrLAIImpl cellGlobalIdOrServiceAreaIdOrLAI = new CellGlobalIdOrServiceAreaIdOrLAIImpl(val);
                return cellGlobalIdOrServiceAreaIdOrLAI;
            }
            throw new MAPParsingComponentException("Error while decoding " + primitiveName + " cellGlobalIdOrServiceAreaIdOrLAI: Parameter length must be 5 or 7", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        CellGlobalIdOrServiceAreaIdOrLAIImpl cellGlobalIdOrServiceAreaIdOrLAI = new CellGlobalIdOrServiceAreaIdOrLAIImpl();
        AsnInputStream ais2 = ais.readSequenceStream();
        ais2.readTag();
        cellGlobalIdOrServiceAreaIdOrLAI.decodeAll(ais2);
        return cellGlobalIdOrServiceAreaIdOrLAI;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cellGlobalIdOrServiceAreaIdOrLAI = null;
        this.routeingAreaIdentity = null;
        this.geographicalInformation = null;
        this.sgsnNumber = null;
        this.selectedLSAIdentity = null;
        this.extensionContainer = null;
        this.saiPresent = false;
        this.geodeticInformation = null;
        this.currentLocationRetrieved = false;
        this.ageOfLocationInformation = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block12: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.cellGlobalIdOrServiceAreaIdOrLAI = LocationInformationGPRSImpl.decodeCellGlobalIdOrServiceAreaIdOrLAI(ais, this._PrimitiveName);
                        continue block12;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " routeingAreaIdentity: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.routeingAreaIdentity = new RAIdentityImpl();
                        ((RAIdentityImpl)this.routeingAreaIdentity).decodeAll(ais);
                        continue block12;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " geographicalInformation: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.geographicalInformation = new GeographicalInformationImpl();
                        ((GeographicalInformationImpl)this.geographicalInformation).decodeAll(ais);
                        continue block12;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " sgsnNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.sgsnNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.sgsnNumber).decodeAll(ais);
                        continue block12;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " selectedLSAIdentity: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.selectedLSAIdentity = new LSAIdentityImpl();
                        ((LSAIdentityImpl)this.selectedLSAIdentity).decodeAll(ais);
                        continue block12;
                    }
                    case 5: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block12;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " saiPresent: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.saiPresent = true;
                        continue block12;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " geodeticInformation: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.geodeticInformation = new GeodeticInformationImpl();
                        ((GeodeticInformationImpl)this.geodeticInformation).decodeAll(ais);
                        continue block12;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " currentLocationRetrieved: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.currentLocationRetrieved = true;
                        continue block12;
                    }
                    case 9: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ageOfLocationInformation: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ageOfLocationInformation = (int)ais.readInteger();
                        continue block12;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.cellGlobalIdOrServiceAreaIdOrLAI != null) {
                asnOs.writeTag(2, false, 0);
                int pos = asnOs.StartContentDefiniteLength();
                ((CellGlobalIdOrServiceAreaIdOrLAIImpl)this.cellGlobalIdOrServiceAreaIdOrLAI).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            if (this.routeingAreaIdentity != null) {
                ((RAIdentityImpl)this.routeingAreaIdentity).encodeAll(asnOs, 2, 1);
            }
            if (this.geographicalInformation != null) {
                ((GeographicalInformationImpl)this.geographicalInformation).encodeAll(asnOs, 2, 2);
            }
            if (this.sgsnNumber != null) {
                ((ISDNAddressStringImpl)this.sgsnNumber).encodeAll(asnOs, 2, 3);
            }
            if (this.selectedLSAIdentity != null) {
                ((LSAIdentityImpl)this.selectedLSAIdentity).encodeAll(asnOs, 2, 4);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 5);
            }
            if (this.saiPresent) {
                try {
                    asnOs.writeNull(2, 6);
                }
                catch (IOException e) {
                    throw new MAPException("Error while encoding LocationInformation the optional parameter sai-Present encoding failed ", e);
                }
                catch (AsnException e) {
                    throw new MAPException("Error while encoding LocationInformation the optional parameter sai-Present encoding failed ", e);
                }
            }
            if (this.geodeticInformation != null) {
                ((GeodeticInformationImpl)this.geodeticInformation).encodeAll(asnOs, 2, 7);
            }
            if (this.currentLocationRetrieved) {
                try {
                    asnOs.writeNull(2, 8);
                }
                catch (IOException e) {
                    throw new MAPException("Error while encoding LocationInformation the optional parameter currentLocationRetrieved encoding failed ", e);
                }
                catch (AsnException e) {
                    throw new MAPException("Error while encoding LocationInformation the optional parameter currentLocationRetrieved encoding failed ", e);
                }
            }
            if (this.ageOfLocationInformation != null) {
                asnOs.writeInteger(2, 9, this.ageOfLocationInformation.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.cellGlobalIdOrServiceAreaIdOrLAI != null) {
            sb.append("cellGlobalIdOrServiceAreaIdOrLAI=");
            sb.append(this.cellGlobalIdOrServiceAreaIdOrLAI);
        }
        if (this.routeingAreaIdentity != null) {
            sb.append(", routeingAreaIdentity=");
            sb.append(this.routeingAreaIdentity);
        }
        if (this.geographicalInformation != null) {
            sb.append(", geographicalInformation=");
            sb.append(this.geographicalInformation);
        }
        if (this.sgsnNumber != null) {
            sb.append(", sgsnNumber=");
            sb.append(this.sgsnNumber);
        }
        if (this.selectedLSAIdentity != null) {
            sb.append(", selectedLSAIdentity=");
            sb.append(this.selectedLSAIdentity);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.saiPresent) {
            sb.append(", saiPresent");
        }
        if (this.geodeticInformation != null) {
            sb.append(", geodeticInformation=");
            sb.append(this.geodeticInformation);
        }
        if (this.currentLocationRetrieved) {
            sb.append(", currentLocationRetrieved");
        }
        if (this.ageOfLocationInformation != null) {
            sb.append(", ageOfLocationInformation=");
            sb.append(this.ageOfLocationInformation);
        }
        sb.append("]");
        return sb.toString();
    }
}

