/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationResponse;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.mobility.MobilityMessageImpl;

public class UpdateLocationResponseImpl
extends MobilityMessageImpl
implements UpdateLocationResponse {
    protected static final int _TAG_pagingArea_Capability = 0;
    public static final String _PrimitiveName = "UpdateLocationResponse";
    private ISDNAddressString hlrNumber;
    private MAPExtensionContainer extensionContainer;
    private boolean addCapability;
    private boolean pagingAreaCapability;
    private long mapProtocolVersion;

    public UpdateLocationResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public UpdateLocationResponseImpl(long mapProtocolVersion, ISDNAddressString hlrNumber, MAPExtensionContainer extensionContainer, boolean addCapability, boolean pagingAreaCapability) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.hlrNumber = hlrNumber;
        this.extensionContainer = extensionContainer;
        this.addCapability = addCapability;
        this.pagingAreaCapability = pagingAreaCapability;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.updateLocation_Response;
    }

    @Override
    public int getOperationCode() {
        return 2;
    }

    @Override
    public ISDNAddressString getHlrNumber() {
        return this.hlrNumber;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public boolean getAddCapability() {
        return this.addCapability;
    }

    @Override
    public boolean getPagingAreaCapability() {
        return this.pagingAreaCapability;
    }

    @Override
    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 2L) {
            return 16;
        }
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 2L;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateLocationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateLocationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateLocationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateLocationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.hlrNumber = null;
        this.extensionContainer = null;
        this.addCapability = false;
        this.pagingAreaCapability = false;
        if (this.mapProtocolVersion >= 2L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                block0 : switch (num) {
                    case 0: {
                        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                            throw new MAPParsingComponentException("Error while decoding UpdateLocationResponse.hlrNumber: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.hlrNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.hlrNumber).decodeAll(ais);
                        break;
                    }
                    default: {
                        if (ais.getTagClass() == 2) {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding UpdateLocationResponse.pagingAreaCapability: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.pagingAreaCapability = true;
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        if (ais.getTagClass() == 0) {
                            switch (tag) {
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding UpdateLocationResponse.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding UpdateLocationResponse.addCapability: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.addCapability = true;
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        ais.advanceElement();
                    }
                }
                ++num;
            }
            if (num < 1) {
                throw new MAPParsingComponentException("Error while decoding UpdateLocationResponse: Needs at least 1 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else {
            this.hlrNumber = new ISDNAddressStringImpl();
            ((ISDNAddressStringImpl)this.hlrNumber).decodeData(ansIS, length);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateLocationResponse: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.hlrNumber == null) {
            throw new MAPException("hlrNumber parameter must not be null");
        }
        try {
            if (this.mapProtocolVersion >= 2L) {
                ((ISDNAddressStringImpl)this.hlrNumber).encodeAll(asnOs);
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
                }
                if (this.addCapability) {
                    asnOs.writeNull();
                }
                if (this.pagingAreaCapability) {
                    asnOs.writeNull(2, 0);
                }
            } else {
                ((ISDNAddressStringImpl)this.hlrNumber).encodeData(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding UpdateLocationResponse: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateLocationResponse: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateLocationResponse [");
        if (this.hlrNumber != null) {
            sb.append("hlrNumber=");
            sb.append(this.hlrNumber.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.addCapability) {
            sb.append("addCapability, ");
        }
        if (this.pagingAreaCapability) {
            sb.append("pagingAreaCapability, ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

