/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.errors.MAPErrorMessageSMDeliveryFailure;
import org.restcomm.protocols.ss7.map.api.errors.SMEnumeratedDeliveryFailureCause;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.smstpdu.SmsDeliverReportTpdu;
import org.restcomm.protocols.ss7.map.api.smstpdu.SmsTpduType;
import org.restcomm.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsTpduImpl;

public class MAPErrorMessageSMDeliveryFailureImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageSMDeliveryFailure {
    private static final String MAP_PROTOCOL_VERSION = "mapProtocolVersion";
    private static final String SM_ENUMERATE_DEL_FAIL_CAUSE = "sMEnumeratedDeliveryFailureCause";
    private static final String SIGNAL_INFO = "signalInfo";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    private long mapProtocolVersion;
    private SMEnumeratedDeliveryFailureCause sMEnumeratedDeliveryFailureCause;
    private byte[] signalInfo;
    private MAPExtensionContainer extensionContainer;
    protected static final XMLFormat<MAPErrorMessageSMDeliveryFailureImpl> MAP_ERROR_MESSAGE_SM_DEL_FAILURE_XML = new XMLFormat<MAPErrorMessageSMDeliveryFailureImpl>(MAPErrorMessageSMDeliveryFailureImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, MAPErrorMessageSMDeliveryFailureImpl errorMessage) throws XMLStreamException {
            ByteArrayContainer bc;
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            errorMessage.mapProtocolVersion = xml.get(MAPErrorMessageSMDeliveryFailureImpl.MAP_PROTOCOL_VERSION, Long.class);
            String str = xml.get(MAPErrorMessageSMDeliveryFailureImpl.SM_ENUMERATE_DEL_FAIL_CAUSE, String.class);
            if (str != null) {
                errorMessage.sMEnumeratedDeliveryFailureCause = Enum.valueOf(SMEnumeratedDeliveryFailureCause.class, str);
            }
            if ((bc = xml.get(MAPErrorMessageSMDeliveryFailureImpl.SIGNAL_INFO, ByteArrayContainer.class)) != null) {
                MAPErrorMessageSMDeliveryFailureImpl.access$202(errorMessage, bc.getData());
            }
            errorMessage.extensionContainer = xml.get(MAPErrorMessageSMDeliveryFailureImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        @Override
        public void write(MAPErrorMessageSMDeliveryFailureImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            xml.add(errorMessage.getMapProtocolVersion(), MAPErrorMessageSMDeliveryFailureImpl.MAP_PROTOCOL_VERSION, Long.class);
            if (errorMessage.getSMEnumeratedDeliveryFailureCause() != null) {
                xml.add(errorMessage.getSMEnumeratedDeliveryFailureCause().toString(), MAPErrorMessageSMDeliveryFailureImpl.SM_ENUMERATE_DEL_FAIL_CAUSE, String.class);
            }
            if (errorMessage.signalInfo != null) {
                ByteArrayContainer bac = new ByteArrayContainer(errorMessage.signalInfo);
                xml.add(bac, MAPErrorMessageSMDeliveryFailureImpl.SIGNAL_INFO, ByteArrayContainer.class);
            }
            xml.add((MAPExtensionContainerImpl)errorMessage.extensionContainer, MAPErrorMessageSMDeliveryFailureImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageSMDeliveryFailureImpl(long mapProtocolVersion, SMEnumeratedDeliveryFailureCause smEnumeratedDeliveryFailureCause, byte[] signalInfo, MAPExtensionContainer extensionContainer) {
        super(32L);
        this.mapProtocolVersion = mapProtocolVersion;
        this.sMEnumeratedDeliveryFailureCause = smEnumeratedDeliveryFailureCause;
        this.signalInfo = signalInfo;
        this.extensionContainer = extensionContainer;
    }

    public MAPErrorMessageSMDeliveryFailureImpl() {
        super(32L);
    }

    @Override
    public SMEnumeratedDeliveryFailureCause getSMEnumeratedDeliveryFailureCause() {
        return this.sMEnumeratedDeliveryFailureCause;
    }

    @Override
    public byte[] getSignalInfo() {
        return this.signalInfo;
    }

    @Override
    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public void setSMEnumeratedDeliveryFailureCause(SMEnumeratedDeliveryFailureCause sMEnumeratedDeliveryFailureCause) {
        this.sMEnumeratedDeliveryFailureCause = sMEnumeratedDeliveryFailureCause;
    }

    @Override
    public void setSignalInfo(byte[] signalInfo) {
        this.signalInfo = signalInfo;
    }

    @Override
    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    @Override
    public void setMapProtocolVersion(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    @Override
    public boolean isEmSMDeliveryFailure() {
        return true;
    }

    @Override
    public MAPErrorMessageSMDeliveryFailure getEmSMDeliveryFailure() {
        return this;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion == 1L) {
            return 10;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.mapProtocolVersion == 1L;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.sMEnumeratedDeliveryFailureCause = null;
        this.signalInfo = null;
        this.extensionContainer = null;
        if (localAis.getTagClass() != 0) {
            throw new MAPParsingComponentException("Error decoding MAPErrorMessageSMDeliveryFailure: bad tag class", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (localAis.getTag()) {
            case 10: {
                if (!localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageSMDeliveryFailure: ENUMERATED tag but data is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                int code = (int)localAis.readIntegerData(length);
                this.sMEnumeratedDeliveryFailureCause = SMEnumeratedDeliveryFailureCause.getInstance(code);
                if (this.sMEnumeratedDeliveryFailureCause == null) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageSMDeliveryFailure.sMEnumeratedDeliveryFailureCause: bad code value", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.mapProtocolVersion = 1L;
                break;
            }
            case 16: {
                if (localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageCallBarred: SEQUENCE tag but data is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais = localAis.readSequenceStreamData(length);
                int tag = ais.readTag();
                if (ais.getTagClass() != 0 || tag != 10) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageSMDeliveryFailure.sMEnumeratedDeliveryFailureCause: bad tag class or tag", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                int code = (int)ais.readInteger();
                this.sMEnumeratedDeliveryFailureCause = SMEnumeratedDeliveryFailureCause.getInstance(code);
                if (this.sMEnumeratedDeliveryFailureCause == null) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageSMDeliveryFailure.sMEnumeratedDeliveryFailureCause: bad value", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                block11: while (ais.available() != 0) {
                    tag = ais.readTag();
                    switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 4: {
                                    this.signalInfo = ais.readOctetString();
                                    continue block11;
                                }
                                case 16: {
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    continue block11;
                                }
                            }
                            ais.advanceElement();
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                }
                this.mapProtocolVersion = 3L;
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws MAPException {
        if (this.sMEnumeratedDeliveryFailureCause == null) {
            throw new MAPException("Error encoding MAPErrorMessageSMDeliveryFailure: parameter sMEnumeratedDeliveryFailureCause must not be null");
        }
        try {
            if (this.mapProtocolVersion < 3L) {
                aos.writeIntegerData(this.sMEnumeratedDeliveryFailureCause.getCode());
            } else {
                aos.writeInteger(0, 10, this.sMEnumeratedDeliveryFailureCause.getCode());
                if (this.signalInfo != null) {
                    aos.writeOctetString(0, 4, this.signalInfo);
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(aos);
                }
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSMDeliveryFailure: " + e.getMessage(), e);
        }
    }

    @Override
    public SmsDeliverReportTpdu getSmsDeliverReportTpdu() throws MAPException {
        SmsTpduImpl smsTpdu;
        if (this.signalInfo != null && (smsTpdu = SmsTpduImpl.createInstance(this.signalInfo, true, null)).getSmsTpduType() == SmsTpduType.SMS_DELIVER_REPORT) {
            SmsDeliverReportTpdu drTpdu = (SmsDeliverReportTpdu)((Object)smsTpdu);
            return drTpdu;
        }
        return null;
    }

    @Override
    public void setSmsDeliverReportTpdu(SmsDeliverReportTpdu tpdu) throws MAPException {
        this.signalInfo = tpdu.encodeData();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAPErrorMessageSMDeliveryFailure [");
        if (this.sMEnumeratedDeliveryFailureCause != null) {
            sb.append("sMEnumeratedDeliveryFailureCause=" + this.sMEnumeratedDeliveryFailureCause.toString());
        }
        if (this.signalInfo != null) {
            sb.append(", signalInfo=" + this.printDataArr(this.signalInfo));
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=" + this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] data) {
        StringBuilder sb = new StringBuilder();
        if (data != null) {
            for (byte b : data) {
                sb.append(b);
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    static /* synthetic */ byte[] access$202(MAPErrorMessageSMDeliveryFailureImpl x0, byte[] x1) {
        x0.signalInfo = x1;
        return x1;
    }
}

