/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.management.transceiver;

import java.nio.ByteBuffer;
import org.mobicents.ss7.management.transceiver.Message;

public class MessageFactory {
    public static final int MESSAGE_HEADER_SIZE = 4;
    private byte[] header = new byte[4];
    private boolean isHeaderReady = false;
    private int pos = 0;
    private int length;
    private byte[] params;
    private Message message;

    protected MessageFactory() {
    }

    public Message createMessage(String message) {
        return new Message(message.getBytes());
    }

    public Message createMessage(ByteBuffer buffer) {
        int len;
        if (!this.isHeaderReady) {
            len = Math.min(4 - this.pos, buffer.remaining());
            buffer.get(this.header, this.pos, len);
            this.pos += len;
            boolean bl = this.isHeaderReady = this.pos == this.header.length;
            if (!this.isHeaderReady) {
                return null;
            }
            this.length = (this.header[0] & 0xFF) << 24;
            this.length += (this.header[1] & 0xFF) << 16;
            this.length += (this.header[2] & 0xFF) << 8;
            this.length += this.header[3] & 0xFF;
            this.length -= 4;
            this.params = new byte[this.length];
            this.pos = 0;
            this.message = new Message();
        }
        if (this.length > 0 && !buffer.hasRemaining()) {
            return null;
        }
        len = Math.min(this.params.length - this.pos, buffer.remaining());
        buffer.get(this.params, this.pos, len);
        this.pos += len;
        if (this.pos < this.params.length) {
            return null;
        }
        this.message.decode(this.params);
        this.isHeaderReady = false;
        this.pos = 0;
        return this.message;
    }
}

