/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ErrorCodeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;

public class ReturnErrorImpl
implements ReturnError {
    private Long invokeId;
    private ErrorCode errorCode;
    private Parameter parameter;

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setErrorCode(ErrorCode ec) {
        this.errorCode = ec;
    }

    public void setInvokeId(Long i) {
        this.invokeId = i;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public ComponentType getType() {
        return ComponentType.ReturnError;
    }

    public String toString() {
        return "ReturnError[invokeId=" + this.invokeId + ", errorCode=" + this.errorCode + ", parameters=" + this.parameter + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnError: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.invokeId = localAis.readInteger();
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            if (localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnError: bad tag class for ErrorCode: tagClass = " + localAis.getTagClass());
            }
            this.errorCode = TcapFactory.createErrorCode();
            switch (tag) {
                case 6: {
                    ((ErrorCodeImpl)this.errorCode).setErrorCodeType(ErrorCodeType.Global);
                    break;
                }
                case 2: {
                    ((ErrorCodeImpl)this.errorCode).setErrorCodeType(ErrorCodeType.Local);
                    break;
                }
                default: {
                    throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding ReturnError: bad tag for ErrorCode: tag= " + tag);
                }
            }
            this.errorCode.decode(localAis);
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            this.parameter = TcapFactory.createParameter(tag, localAis, true);
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding ReturnError: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding ReturnError: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            e.setInvokeId(this.invokeId);
            throw e;
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.invokeId == null) {
            throw new EncodeException("Invoke ID not set!");
        }
        if (this.errorCode == null) {
            throw new EncodeException("Error Code not set!");
        }
        try {
            aos.writeTag(2, false, 3);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId);
            this.errorCode.encode(aos);
            if (this.parameter != null) {
                this.parameter.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding ReturnError: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding ReturnError: " + e.getMessage(), e);
        }
    }
}

