/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.sctp;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.ManagementEventListener;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.api.ServerListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListenerCollection;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMediator;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessage;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessageImpl;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmSeverity;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmList;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmListImpl;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmxss7.Ss7Layer;
import org.mobicents.protocols.ss7.oam.common.sctp.SctpAssociationJmx;
import org.mobicents.protocols.ss7.oam.common.sctp.SctpManagementJmxMBean;
import org.mobicents.protocols.ss7.oam.common.sctp.SctpManagementType;
import org.mobicents.protocols.ss7.oam.common.sctp.SctpServerJmx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SctpManagementJmx
implements SctpManagementJmxMBean,
ManagementEventListener,
AlarmMediator {
    private final MBeanHost ss7Management;
    private final Management wrappedSctpManagement;
    private FastList<Server> lstServers = new FastList();
    private FastMap<String, Association> lstAssociations = new FastMap();
    private AlarmListenerCollection alc = new AlarmListenerCollection();

    public SctpManagementJmx(MBeanHost ss7Management, Management wrappedSctpManagement) {
        this.ss7Management = ss7Management;
        this.wrappedSctpManagement = wrappedSctpManagement;
    }

    @Override
    public Association addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName) throws Exception {
        this.wrappedSctpManagement.addAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName);
        return null;
    }

    @Override
    public Association addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        this.wrappedSctpManagement.addAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName, ipChannelType, extraHostAddresses);
        return null;
    }

    @Override
    public Association addSctpAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName, IpChannelType ipChannelType, String extraHostAddresses) throws Exception {
        this.wrappedSctpManagement.addAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName, ipChannelType, extraHostAddresses != null && !extraHostAddresses.isEmpty() ? extraHostAddresses.split(",") : null);
        return null;
    }

    @Override
    public void addManagementEventListener(ManagementEventListener listener) {
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port) throws Exception {
        this.wrappedSctpManagement.addServer(serverName, hostAddress, port);
        return null;
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        this.wrappedSctpManagement.addServer(serverName, hostAddress, port, ipChannelType, extraHostAddresses);
        return null;
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String[] extraHostAddresses) throws Exception {
        this.wrappedSctpManagement.addServer(serverName, hostAddress, port, ipChannelType, acceptAnonymousConnections, maxConcurrentConnectionsCount, extraHostAddresses);
        return null;
    }

    @Override
    public Server addSctpServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String extraHostAddresses) throws Exception {
        this.wrappedSctpManagement.addServer(serverName, hostAddress, port, ipChannelType, acceptAnonymousConnections, maxConcurrentConnectionsCount, extraHostAddresses != null && !extraHostAddresses.isEmpty() ? extraHostAddresses.split(",") : null);
        return null;
    }

    @Override
    public Association addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName) throws Exception {
        this.wrappedSctpManagement.addServerAssociation(peerAddress, peerPort, serverName, assocName);
        return null;
    }

    @Override
    public Association addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName, IpChannelType ipChannelType) throws Exception {
        this.wrappedSctpManagement.addServerAssociation(peerAddress, peerPort, serverName, assocName, ipChannelType);
        return null;
    }

    @Override
    public Association addSctpServerAssociation(String peerAddress, int peerPort, String serverName, String assocName, IpChannelType ipChannelType) throws Exception {
        this.wrappedSctpManagement.addServerAssociation(peerAddress, peerPort, serverName, assocName, ipChannelType);
        return null;
    }

    @Override
    public Association getAssociation(String assocName) throws Exception {
        FastCollection.Record n = this.lstAssociations.head();
        FastMap.Entry<String, Association> end = this.lstAssociations.tail();
        while ((n = ((FastMap.Entry)n).getNext()) != end) {
            String key = (String)((FastMap.Entry)n).getKey();
            if (!key.equals(assocName)) continue;
            return (Association)((FastMap.Entry)n).getValue();
        }
        return null;
    }

    @Override
    public Map<String, Association> getAssociations() {
        HashMap<String, Association> lstAssociationsTmp = new HashMap<String, Association>();
        lstAssociationsTmp.putAll(this.lstAssociations);
        return lstAssociationsTmp;
    }

    @Override
    public int getConnectDelay() {
        return this.wrappedSctpManagement.getConnectDelay();
    }

    @Override
    public String getName() {
        return this.wrappedSctpManagement.getName();
    }

    @Override
    public String getPersistDir() {
        return this.wrappedSctpManagement.getPersistDir();
    }

    @Override
    public ServerListener getServerListener() {
        return null;
    }

    @Override
    public List<Server> getServers() {
        return this.lstServers.unmodifiable();
    }

    @Override
    public int getWorkerThreads() {
        return this.wrappedSctpManagement.getWorkerThreads();
    }

    @Override
    public boolean isSingleThread() {
        return this.wrappedSctpManagement.isSingleThread();
    }

    @Override
    public boolean isStarted() {
        return this.wrappedSctpManagement.isStarted();
    }

    @Override
    public void removeAllResourses() throws Exception {
        this.wrappedSctpManagement.removeAllResourses();
    }

    @Override
    public void removeAssociation(String assocName) throws Exception {
        this.wrappedSctpManagement.removeAssociation(assocName);
    }

    @Override
    public void removeManagementEventListener(ManagementEventListener arg0) {
    }

    @Override
    public void removeServer(String serverName) throws Exception {
        this.wrappedSctpManagement.removeServer(serverName);
    }

    @Override
    public void setConnectDelay(int connectDelay) throws Exception {
        this.wrappedSctpManagement.setConnectDelay(connectDelay);
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.wrappedSctpManagement.setPersistDir(persistDir);
    }

    @Override
    public void setServerListener(ServerListener arg0) {
    }

    @Override
    public void setSingleThread(boolean singleThread) throws Exception {
        this.wrappedSctpManagement.setSingleThread(singleThread);
    }

    @Override
    public void setWorkerThreads(int workerThreads) throws Exception {
        this.wrappedSctpManagement.setWorkerThreads(workerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            this.lstServers.clear();
            this.lstAssociations.clear();
            this.ss7Management.registerMBean(Ss7Layer.SCTP, SctpManagementType.MANAGEMENT, this.getName(), this);
            this.wrappedSctpManagement.addManagementEventListener(this);
            List<Server> lstSrv = this.wrappedSctpManagement.getServers();
            for (Server srv : lstSrv) {
                this.addServerToManagement(srv);
            }
            Map<String, Association> lstAss = this.wrappedSctpManagement.getAssociations();
            for (String s : lstAss.keySet()) {
                Association asso = lstAss.get(s);
                this.addAssociationToManagement(asso);
            }
        }
    }

    @Override
    public void startAssociation(String assocName) throws Exception {
        this.wrappedSctpManagement.startAssociation(assocName);
    }

    @Override
    public void startServer(String serverName) throws Exception {
        this.wrappedSctpManagement.startServer(serverName);
    }

    @Override
    public void stop() throws Exception {
        this.removeAllResourcesFromManagement();
    }

    @Override
    public void stopAssociation(String assocName) throws Exception {
        this.wrappedSctpManagement.stopAssociation(assocName);
    }

    @Override
    public void stopServer(String serverName) throws Exception {
        this.wrappedSctpManagement.stopServer(serverName);
    }

    @Override
    public void onAssociationAdded(Association asso) {
        this.addAssociationToManagement(asso);
    }

    @Override
    public void onAssociationDown(Association asso) {
        if (asso.isStarted()) {
            AlarmMessage alm = this.generateAssociationAlarm(asso, false, false, "onAssociationDown");
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAssociationRemoved(Association asso) {
        this.removeAssociationFromManagement(asso);
    }

    @Override
    public void onAssociationStarted(Association ass) {
        if (!ass.isConnected()) {
            AlarmMessage alm = this.generateAssociationAlarm(ass, false, false, "onAssociationStarted");
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAssociationStopped(Association ass) {
        if (!ass.isConnected()) {
            AlarmMessage alm = this.generateAssociationAlarm(ass, true, false, "onAssociationStopped");
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAssociationUp(Association ass) {
        if (ass.isStarted()) {
            AlarmMessage alm = this.generateAssociationAlarm(ass, true, false, "onAssociationUp");
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onRemoveAllResources() {
        this.removeAllResourcesFromManagement();
    }

    @Override
    public void onServerAdded(Server srv) {
        this.addServerToManagement(srv);
    }

    @Override
    public void onServerRemoved(Server srv) {
        this.removeServerFromManagement(srv);
    }

    @Override
    public void onServiceStarted() {
    }

    @Override
    public void onServiceStopped() {
    }

    @Override
    public String getAlarmProviderObjectPath() {
        return this.alc.getAlarmProviderObjectPath();
    }

    @Override
    public CurrentAlarmList getCurrentAlarmList() {
        CurrentAlarmListImpl al = new CurrentAlarmListImpl();
        if (this.wrappedSctpManagement.isStarted()) {
            Map<String, Association> lstAss = this.wrappedSctpManagement.getAssociations();
            for (Association ass : lstAss.values()) {
                if (!ass.isStarted() || ass.isConnected()) continue;
                AlarmMessage alm = this.generateAssociationAlarm(ass, false, true, "");
                this.alc.prepareAlarm(alm);
                al.addAlarm(alm);
            }
        }
        return al;
    }

    @Override
    public void registerAlarmListener(AlarmListener al) {
        this.alc.registerAlarmListener(al);
    }

    @Override
    public void setAlarmProviderObjectPath(String value) {
        this.alc.setAlarmProviderObjectPath(value);
    }

    @Override
    public void unregisterAlarmListener(AlarmListener al) {
        this.alc.unregisterAlarmListener(al);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssociationToManagement(Association asso) {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            SctpAssociationJmx assBean = new SctpAssociationJmx(this, asso);
            this.ss7Management.registerMBean(Ss7Layer.SCTP, SctpManagementType.ASSOCIATION, asso.getName(), assBean);
            this.lstAssociations.put(asso.getName(), assBean);
        }
    }

    private AlarmMessage generateAssociationAlarm(Association ass, boolean isCleared, boolean isCurrentAlarmList, String event) {
        AlarmMessageImpl alm = new AlarmMessageImpl();
        alm.setIsCleared(isCleared);
        alm.setAlarmSeverity(AlarmSeverity.minor);
        alm.setAlarmSource("SS7_SCTP_" + this.getName());
        alm.setObjectName("Association: " + ass.getName());
        alm.setObjectPath("/Sctp:" + this.getName() + "/Associations/Association:" + ass.getName());
        alm.setProblemName("SCTP association is down");
        alm.setCause(event);
        alm.setTimeAlarm(Calendar.getInstance());
        if (!isCurrentAlarmList) {
            if (isCleared) {
                alm.setCurentTimeClear();
            } else {
                alm.setCurentTimeAlarm();
            }
        }
        return alm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAssociationFromManagement(Association asso) {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            this.lstAssociations.remove(asso.getName());
            this.ss7Management.unregisterMBean(Ss7Layer.SCTP, SctpManagementType.ASSOCIATION, asso.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllResourcesFromManagement() {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            Map<String, Association> lstAss = this.wrappedSctpManagement.getAssociations();
            for (String s : lstAss.keySet()) {
                Association asso = lstAss.get(s);
                this.removeAssociationFromManagement(asso);
            }
            List<Server> lstServ = this.wrappedSctpManagement.getServers();
            for (Server srv : lstServ) {
                this.removeServerFromManagement(srv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerFromManagement(Server srv) {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            Server srvBeanX = null;
            for (Server srvBean : this.lstServers) {
                if (!srvBean.getName().equals(srv.getName())) continue;
                srvBeanX = srvBean;
                break;
            }
            this.lstServers.remove(srvBeanX);
            this.ss7Management.unregisterMBean(Ss7Layer.SCTP, SctpManagementType.SERVER, srv.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerToManagement(Server srv) {
        SctpManagementJmx sctpManagementJmx = this;
        synchronized (sctpManagementJmx) {
            SctpServerJmx srvBean = new SctpServerJmx(this, srv);
            this.ss7Management.registerMBean(Ss7Layer.SCTP, SctpManagementType.SERVER, srv.getName(), srvBean);
            this.lstServers.add(srvBean);
        }
    }
}

