/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanLayer;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;

public class MBeanHostImpl
implements MBeanHost {
    protected static final Logger logger = Logger.getLogger(MBeanHostImpl.class);
    public static final String DEFAULT_DOMAIN_NAME = "org.mobicents.ss7";
    private String agentId;
    private int rmiPort;
    private String domainName = "org.mobicents.ss7";
    private MBeanServer mBeanServer;
    private Registry reg;
    private JMXConnectorServer cs;
    protected ArrayList<ObjectName> lstRegisteredBeans = new ArrayList();

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String val) {
        this.agentId = val;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int val) {
        this.rmiPort = val;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void start() {
        boolean servFound = false;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && servers.size() > 0) {
            for (MBeanServer server : servers) {
                String defaultDomain = server.getDefaultDomain();
                if (defaultDomain != null && defaultDomain.equals(this.agentId)) {
                    this.mBeanServer = server;
                    servFound = true;
                    logger.info(String.format("Found MBeanServer matching for agentId=%s", this.agentId));
                    continue;
                }
                logger.warn(String.format("Found non-matching MBeanServer with default domian = %s", defaultDomain));
            }
        }
        if (!servFound) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (this.rmiPort > 0) {
                try {
                    this.reg = LocateRegistry.createRegistry(this.rmiPort);
                    JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + this.rmiPort + "/server");
                    this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mBeanServer);
                    this.cs.start();
                }
                catch (RemoteException e) {
                    logger.error("RemoteException when creating and starting JMXConnectorServer", e);
                }
                catch (MalformedURLException e) {
                    logger.error("MalformedURLException when creating and starting JMXConnectorServer", e);
                }
                catch (IOException e) {
                    logger.error("IOException when creating and starting JMXConnectorServer", e);
                }
            }
        }
    }

    public void stop() {
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (IOException e) {
                logger.error("IOException when stopping JMXConnectorServer", e);
            }
            this.cs = null;
        }
        for (ObjectName on : this.lstRegisteredBeans) {
            try {
                this.mBeanServer.unregisterMBean(on);
            }
            catch (MBeanRegistrationException e) {
                logger.error("MBeanRegistrationException when unregisterMBean", e);
            }
            catch (InstanceNotFoundException e) {
                logger.error("InstanceNotFoundException when unregisterMBean", e);
            }
        }
        if (this.reg != null) {
            try {
                UnicastRemoteObject.unexportObject(this.reg, true);
            }
            catch (NoSuchObjectException e) {
                logger.error("NoSuchObjectException when unexportObject", e);
            }
            this.reg = null;
        }
    }

    protected ObjectName createObjectName(MBeanLayer layer, MBeanType type, String name) throws MalformedObjectNameException {
        return new ObjectName(this.domainName + ":layer=" + layer.getName() + ",type=" + type.getName() + ",name=" + name);
    }

    public void registerMBean(MBeanLayer layer, MBeanType type, String name, Object bean) {
        if (this.mBeanServer != null) {
            try {
                ObjectName on = this.createObjectName(layer, type, name);
                this.mBeanServer.registerMBean(bean, on);
                this.lstRegisteredBeans.add(on);
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Registered MBean with ObjectName=%s", on));
                }
            }
            catch (Exception e) {
                logger.error(String.format("Error while trying to regisetr MBean for Layer=%s Type=%s name=%s", layer, type, name), e);
            }
        } else {
            logger.error(String.format("mBeanServer is null. Cannot register MBean for Layer=%s Type=%s name=%s", layer, type, name));
        }
    }

    public Object unregisterMBean(MBeanLayer layer, MBeanType type, String name) {
        Boolean bean = null;
        if (this.mBeanServer != null) {
            try {
                ObjectName on = this.createObjectName(layer, type, name);
                this.mBeanServer.unregisterMBean(on);
                bean = this.lstRegisteredBeans.remove(on);
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Unregistered MBean with ObjectName=%s", on));
                }
            }
            catch (Exception e) {
                logger.error(String.format("Error while trying to unregisetr MBean for Layer=%s Type=%s name=%s", layer, type, name), e);
            }
        } else {
            logger.error(String.format("mBeanServer is null. Cannot register MBean for Layer=%s Type=%s name=%s", layer, type, name));
        }
        return bean;
    }
}

