/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationSetList;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.CurrentSecurityContext;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationResponse;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.AuthenticationSetListImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.CurrentSecurityContextImpl;

public class SendIdentificationResponseImpl
extends MobilityMessageImpl
implements SendIdentificationResponse {
    protected static final int _TAG_currentSecurityContext = 2;
    protected static final int _TAG_extensionContainer = 3;
    public static final int _TAG_SendIdentificationResponse = 3;
    public static final String _PrimitiveName = "SendIdentificationResponse";
    private IMSI imsi;
    private AuthenticationSetList authenticationSetList;
    private CurrentSecurityContext currentSecurityContext;
    private MAPExtensionContainer extensionContainer;
    private long mapProtocolVersion;

    public SendIdentificationResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public SendIdentificationResponseImpl(IMSI imsi, AuthenticationSetList authenticationSetList, CurrentSecurityContext currentSecurityContext, MAPExtensionContainer extensionContainer, long mapProtocolVersion) {
        this.imsi = imsi;
        this.authenticationSetList = authenticationSetList;
        this.currentSecurityContext = currentSecurityContext;
        this.extensionContainer = extensionContainer;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendIdentification_Response;
    }

    public int getOperationCode() {
        return 55;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 3;
        }
        return 16;
    }

    public int getTagClass() {
        if (this.mapProtocolVersion >= 3L) {
            return 2;
        }
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public AuthenticationSetList getAuthenticationSetList() {
        return this.authenticationSetList;
    }

    public CurrentSecurityContext getCurrentSecurityContext() {
        return this.currentSecurityContext;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendIdentificationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendIdentificationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendIdentificationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendIdentificationResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.authenticationSetList = null;
        this.currentSecurityContext = null;
        this.extensionContainer = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            while (ais.available() != 0) {
                int tag = ais.readTag();
                block0 : switch (ais.getTagClass()) {
                    case 0: {
                        switch (tag) {
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse.imsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.imsi = new IMSIImpl();
                                ((IMSIImpl)this.imsi).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    case 2: {
                        switch (tag) {
                            case 0: 
                            case 1: {
                                this.authenticationSetList = new AuthenticationSetListImpl();
                                ((AuthenticationSetListImpl)this.authenticationSetList).decodeAll(ais);
                                break block0;
                            }
                            case 2: {
                                AsnInputStream ais2 = ais.readSequenceStream();
                                ais2.readTag();
                                this.currentSecurityContext = new CurrentSecurityContextImpl();
                                ((CurrentSecurityContextImpl)this.currentSecurityContext).decodeAll(ais2);
                                break block0;
                            }
                            case 3: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse.extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
            }
        } else {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            block20: while (ais.available() != 0) {
                int tag = ais.readTag();
                switch (ais.getTagClass()) {
                    case 0: {
                        switch (tag) {
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse.imsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.imsi = new IMSIImpl();
                                ((IMSIImpl)this.imsi).decodeAll(ais);
                                continue block20;
                            }
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse.authenticationSetList: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.authenticationSetList = new AuthenticationSetListImpl();
                                ((AuthenticationSetListImpl)this.authenticationSetList).decodeAll(ais);
                                continue block20;
                            }
                        }
                        ais.advanceElement();
                        continue block20;
                    }
                }
                ais.advanceElement();
            }
            if (this.imsi == null) {
                throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse: imsi is mandatory for MAP V2 but not found ", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendIdentificationResponse: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            try {
                if (this.imsi != null) {
                    ((IMSIImpl)this.imsi).encodeAll(asnOs);
                }
                if (this.authenticationSetList != null) {
                    ((AuthenticationSetListImpl)this.authenticationSetList).encodeAll(asnOs);
                }
                if (this.currentSecurityContext != null) {
                    asnOs.writeTag(2, false, 2);
                    int pos = asnOs.StartContentDefiniteLength();
                    ((CurrentSecurityContextImpl)this.currentSecurityContext).encodeAll(asnOs);
                    asnOs.FinalizeContent(pos);
                }
                if (this.extensionContainer == null) return;
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
                return;
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding SendIdentificationResponse: " + e.getMessage(), e);
            }
        } else {
            if (this.imsi == null) {
                throw new MAPException("Error while encoding SendIdentificationResponse the mandatory parameter imsi is not defined");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            if (this.authenticationSetList == null) return;
            ((AuthenticationSetListImpl)this.authenticationSetList).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.authenticationSetList != null) {
            sb.append("authenticationSetList=");
            sb.append(this.authenticationSetList.toString());
            sb.append(", ");
        }
        if (this.currentSecurityContext != null) {
            sb.append("currentSecurityContext=");
            sb.append(this.currentSecurityContext.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

