/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationTriplet;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.TripletList;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.AuthenticationTripletImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripletListImpl
implements TripletList,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "TripletList";
    private ArrayList<AuthenticationTriplet> authenticationTriplets;

    public TripletListImpl() {
    }

    public TripletListImpl(ArrayList<AuthenticationTriplet> authenticationTriplets) {
        this.authenticationTriplets = authenticationTriplets;
    }

    @Override
    public ArrayList<AuthenticationTriplet> getAuthenticationTriplets() {
        return this.authenticationTriplets;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding TripletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding TripletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding TripletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding TripletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.authenticationTriplets = new ArrayList();
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding TripletList: Parameter AuthenticationTriplet is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AuthenticationTripletImpl at = new AuthenticationTripletImpl();
                        at.decodeAll(ais);
                        this.authenticationTriplets.add(at);
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.authenticationTriplets.size() < 1 || this.authenticationTriplets.size() > 5) {
            throw new MAPParsingComponentException("Error while decoding TripletList: authenticationTriplets must be from 1 to 5, found:" + this.authenticationTriplets.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding TripletList: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.authenticationTriplets == null || this.authenticationTriplets.size() < 1 || this.authenticationTriplets.size() > 5) {
            throw new MAPException("AuthenticationTriplets list must contains from 1 to 5 elemets");
        }
        for (AuthenticationTriplet at : this.authenticationTriplets) {
            ((AuthenticationTripletImpl)at).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TripletList [");
        if (this.authenticationTriplets != null) {
            for (AuthenticationTriplet at : this.authenticationTriplets) {
                if (at == null) continue;
                sb.append(at.toString());
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

