/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import java.util.HashMap;
import org.mobicents.protocols.ss7.m3ua.message.M3UAMessage;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.Status;

public class TransitionState {
    public static final String COMM_UP = "commup";
    public static final String COMM_DOWN = "commdown";
    public static final String PAYLOAD = "payload";
    public static final String DUNA = "duna";
    public static final String DAVA = "dava";
    public static final String DAUD = "daud";
    public static final String SCON = "scon";
    public static final String DUPU = "dupu";
    public static final String DRST = "drst";
    public static final String ASP_UP_SENT = "aspupsent";
    public static final String ASP_UP = "aspup";
    public static final String ASP_UP_ACK = "aspupack";
    public static final String ASP_DOWN_SENT = "aspdownsent";
    public static final String ASP_DOWN = "aspdown";
    public static final String ASP_DOWN_ACK = "aspdownack";
    public static final String HEARTBEAT = "heartbeat";
    public static final String HEARTBEAT_ACK = "heartbeatack";
    public static final String ASP_INACTIVE_SENT = "aspinactivesent";
    public static final String ASP_INACTIVE = "aspinactive";
    public static final String ASP_INACTIVE_ACK = "aspinactiveack";
    public static final String ASP_ACTIVE = "aspactive";
    public static final String ASP_ACTIVE_SENT = "aspactivesent";
    public static final String ASP_ACTIVE_ACK = "aspactiveack";
    public static final String AS_DOWN = "asdown";
    public static final String AS_INACTIVE = "asinactive";
    public static final String AS_STATE_CHANGE_RESERVE = "ntfyreserve";
    public static final String AS_STATE_CHANGE_INACTIVE = "ntfyasinactive";
    public static final String AS_STATE_CHANGE_ACTIVE = "ntfyasactive";
    public static final String AS_STATE_CHANGE_PENDING = "ntfyaspending";
    public static final String OTHER_INSUFFICIENT_ASP = "ntfyinsuffasp";
    public static final String OTHER_ALTERNATE_ASP_ACTIVE = "ntfyaltaspact";
    public static final String OTHER_ALTERNATE_ASP_FAILURE = "ntfyaltaspfail";
    public static final String INVALID_RC = "invalidrc";
    private static HashMap<Integer, HashMap<Integer, String>> transContainer = new HashMap();

    public static String getTransition(M3UAMessage message) {
        switch (message.getMessageClass()) {
            case 0: {
                switch (message.getMessageType()) {
                    case 0: 
                    case 1: {
                        Status status = ((Notify)message).getStatus();
                        return transContainer.get(message.getMessageClass()).get(status.getType() << 16 | status.getInfo());
                    }
                }
            }
        }
        return transContainer.get(message.getMessageClass()).get(message.getMessageType());
    }

    static {
        HashMap<Integer, String> trfrTransCont = new HashMap<Integer, String>();
        trfrTransCont.put(1, PAYLOAD);
        transContainer.put(1, trfrTransCont);
        HashMap<Integer, String> ssnmTransCont = new HashMap<Integer, String>();
        ssnmTransCont.put(1, DUNA);
        ssnmTransCont.put(2, DAVA);
        ssnmTransCont.put(3, DAUD);
        ssnmTransCont.put(4, SCON);
        ssnmTransCont.put(5, DUPU);
        ssnmTransCont.put(6, DRST);
        transContainer.put(2, ssnmTransCont);
        HashMap<Integer, String> aspsmTransCont = new HashMap<Integer, String>();
        aspsmTransCont.put(1, ASP_UP);
        aspsmTransCont.put(4, ASP_UP_ACK);
        aspsmTransCont.put(2, ASP_DOWN);
        aspsmTransCont.put(5, ASP_DOWN_ACK);
        aspsmTransCont.put(3, HEARTBEAT);
        aspsmTransCont.put(6, HEARTBEAT_ACK);
        transContainer.put(3, aspsmTransCont);
        HashMap<Integer, String> asptmTransCont = new HashMap<Integer, String>();
        asptmTransCont.put(1, ASP_ACTIVE);
        asptmTransCont.put(3, ASP_ACTIVE_ACK);
        asptmTransCont.put(2, ASP_INACTIVE);
        asptmTransCont.put(4, ASP_INACTIVE_ACK);
        transContainer.put(4, asptmTransCont);
        HashMap<Integer, String> mgmtTransCont = new HashMap<Integer, String>();
        mgmtTransCont.put(65537, AS_STATE_CHANGE_RESERVE);
        mgmtTransCont.put(65538, AS_STATE_CHANGE_INACTIVE);
        mgmtTransCont.put(65539, AS_STATE_CHANGE_ACTIVE);
        mgmtTransCont.put(65540, AS_STATE_CHANGE_PENDING);
        mgmtTransCont.put(131073, OTHER_INSUFFICIENT_ASP);
        mgmtTransCont.put(131074, OTHER_ALTERNATE_ASP_ACTIVE);
        mgmtTransCont.put(131075, OTHER_ALTERNATE_ASP_FAILURE);
        mgmtTransCont.put(25, INVALID_RC);
        transContainer.put(0, mgmtTransCont);
    }
}

