/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.ClosedUserGroupInterlockCode;

public class ClosedUserGroupInterlockCodeImpl
extends AbstractISUPParameter
implements ClosedUserGroupInterlockCode {
    private byte[] niDigits = null;
    private int binaryCode = 0;

    public ClosedUserGroupInterlockCodeImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public ClosedUserGroupInterlockCodeImpl() {
    }

    public ClosedUserGroupInterlockCodeImpl(byte[] niDigits, int binaryCode) {
        this.setNiDigits(niDigits);
        this.binaryCode = binaryCode;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 4) {
            throw new ParameterException("byte[] must not be null and must have length of 4");
        }
        byte v = 0;
        this.niDigits = new byte[4];
        for (int i = 0; i < 2; ++i) {
            v = 0;
            v = b[i];
            this.niDigits[i * 2] = (byte)(v >> 4 & 0xF);
            this.niDigits[i * 2 + 1] = (byte)(v & 0xF);
        }
        this.binaryCode = b[2] << 8 & 0xFF00;
        this.binaryCode |= b[3];
        return 4;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = new byte[4];
        int v = 0;
        for (int i = 0; i < 2; ++i) {
            v = 0;
            v |= (this.niDigits[i * 2] & 0xF) << 4;
            b[i] = (byte)(v |= this.niDigits[i * 2 + 1] & 0xF);
        }
        b[2] = (byte)(this.binaryCode >> 8);
        b[3] = (byte)this.binaryCode;
        return b;
    }

    public byte[] getNiDigits() {
        return this.niDigits;
    }

    public void setNiDigits(byte[] niDigits) {
        if (niDigits == null || niDigits.length != 4) {
            throw new IllegalArgumentException();
        }
        this.niDigits = niDigits;
    }

    public int getBinaryCode() {
        return this.binaryCode;
    }

    public void setBinaryCode(int binaryCode) {
        this.binaryCode = binaryCode;
    }

    public int getCode() {
        return 26;
    }
}

