/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ConnectGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.AccessPointName;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPID;
import org.mobicents.protocols.ss7.cap.service.gprs.GprsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.AccessPointNameImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.PDPIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ConnectGPRSRequestImpl
extends GprsMessageImpl
implements ConnectGPRSRequest {
    public static final String _PrimitiveName = "ConnectGPRSRequest";
    public static final int _ID_accessPointName = 0;
    public static final int _ID_pdpID = 1;
    private AccessPointName accessPointName;
    private PDPID pdpID;

    public ConnectGPRSRequestImpl() {
    }

    public ConnectGPRSRequestImpl(AccessPointName accessPointName, PDPID pdpID) {
        this.accessPointName = accessPointName;
        this.pdpID = pdpID;
    }

    public AccessPointName getAccessPointName() {
        return this.accessPointName;
    }

    public PDPID getPDPID() {
        return this.pdpID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.connectGPRS_Request;
    }

    public int getOperationCode() {
        return 74;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.accessPointName = null;
        this.pdpID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectGPRSRequest.accessPointName: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.accessPointName = new AccessPointNameImpl();
                        ((AccessPointNameImpl)this.accessPointName).decodeAll(ais);
                        continue block4;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectGPRSRequest.pdpID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpID = new PDPIDImpl();
                        ((PDPIDImpl)this.pdpID).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.accessPointName == null) {
            throw new CAPParsingComponentException("Error while decoding ConnectGPRSRequest: parameter accessPointName is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectGPRSRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.accessPointName == null) {
            throw new CAPException("Error while encoding ConnectGPRSRequest: accessPointName must not be null");
        }
        ((AccessPointNameImpl)this.accessPointName).encodeAll(asnOs, 2, 0);
        if (this.pdpID != null) {
            ((PDPIDImpl)this.pdpID).encodeAll(asnOs, 2, 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectGPRSRequest [");
        this.addInvokeIdInfo(sb);
        if (this.accessPointName != null) {
            sb.append(", accessPointName=");
            sb.append(this.accessPointName.toString());
            sb.append(", ");
        }
        if (this.pdpID != null) {
            sb.append(", pdpID=");
            sb.append(this.pdpID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

