/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.InbandInfo;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.MessageID;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.MessageIDImpl;

public class InbandInfoImpl
extends SequenceBase
implements InbandInfo {
    public static final int _ID_messageID = 0;
    public static final int _ID_numberOfRepetitions = 1;
    public static final int _ID_duration = 2;
    public static final int _ID_interval = 3;
    private static final String MESSAGE_ID = "messageID";
    private static final String NUMBER_OF_REPETITIONS = "numberOfRepetitions";
    private static final String DURATION = "duration";
    private static final String INTERVAL = "interval";
    private MessageID messageID;
    private Integer numberOfRepetitions;
    private Integer duration;
    private Integer interval;
    protected static final XMLFormat<InbandInfoImpl> INBAND_INFO_XML = new XMLFormat<InbandInfoImpl>(InbandInfoImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, InbandInfoImpl inbandInfo) throws XMLStreamException {
            int vali = xml.getAttribute(InbandInfoImpl.NUMBER_OF_REPETITIONS, -1);
            if (vali != -1) {
                inbandInfo.numberOfRepetitions = vali;
            }
            if ((vali = xml.getAttribute(InbandInfoImpl.DURATION, -1)) != -1) {
                inbandInfo.duration = vali;
            }
            if ((vali = xml.getAttribute(InbandInfoImpl.INTERVAL, -1)) != -1) {
                inbandInfo.interval = vali;
            }
            inbandInfo.messageID = xml.get(InbandInfoImpl.MESSAGE_ID, MessageIDImpl.class);
        }

        @Override
        public void write(InbandInfoImpl inbandInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (inbandInfo.numberOfRepetitions != null) {
                xml.setAttribute(InbandInfoImpl.NUMBER_OF_REPETITIONS, inbandInfo.numberOfRepetitions);
            }
            if (inbandInfo.duration != null) {
                xml.setAttribute(InbandInfoImpl.DURATION, inbandInfo.duration);
            }
            if (inbandInfo.interval != null) {
                xml.setAttribute(InbandInfoImpl.INTERVAL, inbandInfo.interval);
            }
            xml.add((MessageIDImpl)inbandInfo.messageID, InbandInfoImpl.MESSAGE_ID, MessageIDImpl.class);
        }
    };

    public InbandInfoImpl() {
        super("InbandInfo");
    }

    public InbandInfoImpl(MessageID messageID, Integer numberOfRepetitions, Integer duration, Integer interval) {
        super("InbandInfo");
        this.messageID = messageID;
        this.numberOfRepetitions = numberOfRepetitions;
        this.duration = duration;
        this.interval = interval;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public Integer getNumberOfRepetitions() {
        return this.numberOfRepetitions;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getInterval() {
        return this.interval;
    }

    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.messageID = null;
        this.numberOfRepetitions = null;
        this.duration = null;
        this.interval = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.messageID = new MessageIDImpl();
                        ((MessageIDImpl)this.messageID).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        this.numberOfRepetitions = (int)ais.readInteger();
                        break;
                    }
                    case 2: {
                        this.duration = (int)ais.readInteger();
                        break;
                    }
                    case 3: {
                        this.interval = (int)ais.readInteger();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.messageID == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": messageID is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.messageID == null) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": messageID must not be null");
        }
        try {
            aos.writeTag(2, false, 0);
            int pos = aos.StartContentDefiniteLength();
            ((MessageIDImpl)this.messageID).encodeAll(aos);
            aos.FinalizeContent(pos);
            if (this.numberOfRepetitions != null) {
                aos.writeInteger(2, 1, this.numberOfRepetitions.intValue());
            }
            if (this.duration != null) {
                aos.writeInteger(2, 2, this.duration.intValue());
            }
            if (this.interval != null) {
                aos.writeInteger(2, 3, this.interval.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.messageID != null) {
            sb.append("messageID=");
            sb.append(this.messageID.toString());
        }
        if (this.numberOfRepetitions != null) {
            sb.append(", numberOfRepetitions=");
            sb.append(this.numberOfRepetitions);
        }
        if (this.duration != null) {
            sb.append(", duration=");
            sb.append(this.duration);
        }
        if (this.interval != null) {
            sb.append(", interval=");
            sb.append(this.interval);
        }
        sb.append("]");
        return sb.toString();
    }
}

