/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageRequestedInfoError;
import org.mobicents.protocols.ss7.cap.api.errors.RequestedInfoErrorParameter;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageImpl;

public class CAPErrorMessageRequestedInfoErrorImpl
extends CAPErrorMessageImpl
implements CAPErrorMessageRequestedInfoError {
    private static final String REQUESTED_INFO_ERROR_PARAMETER = "requestedInfoErrorParameter";
    public static final String _PrimitiveName = "CAPErrorMessageRequestedInfoError";
    private RequestedInfoErrorParameter requestedInfoErrorParameter;
    protected static final XMLFormat<CAPErrorMessageRequestedInfoErrorImpl> CAP_ERROR_MESSAGE_REQUESTED_INFO_ERROR_XML = new XMLFormat<CAPErrorMessageRequestedInfoErrorImpl>(CAPErrorMessageRequestedInfoErrorImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CAPErrorMessageRequestedInfoErrorImpl errorMessage) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            String str = xml.get(CAPErrorMessageRequestedInfoErrorImpl.REQUESTED_INFO_ERROR_PARAMETER, String.class);
            if (str != null) {
                errorMessage.requestedInfoErrorParameter = Enum.valueOf(RequestedInfoErrorParameter.class, str);
            }
        }

        @Override
        public void write(CAPErrorMessageRequestedInfoErrorImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            if (errorMessage.requestedInfoErrorParameter != null) {
                xml.add(errorMessage.requestedInfoErrorParameter.toString(), CAPErrorMessageRequestedInfoErrorImpl.REQUESTED_INFO_ERROR_PARAMETER, String.class);
            }
        }
    };

    protected CAPErrorMessageRequestedInfoErrorImpl(RequestedInfoErrorParameter requestedInfoErrorParameter) {
        super(10L);
        this.requestedInfoErrorParameter = requestedInfoErrorParameter;
    }

    public CAPErrorMessageRequestedInfoErrorImpl() {
        super(10L);
    }

    public boolean isEmRequestedInfoError() {
        return true;
    }

    public CAPErrorMessageRequestedInfoError getEmRequestedInfoError() {
        return this;
    }

    public RequestedInfoErrorParameter getRequestedInfoErrorParameter() {
        return this.requestedInfoErrorParameter;
    }

    public int getTag() throws CAPException {
        return 10;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.requestedInfoErrorParameter = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 10 || !localAis.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error decoding CAPErrorMessageRequestedInfoError: bad tag class or tag or parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        int i1 = (int)localAis.readIntegerData(length);
        this.requestedInfoErrorParameter = RequestedInfoErrorParameter.getInstance(i1);
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.requestedInfoErrorParameter == null) {
            throw new CAPException("Error while encoding CAPErrorMessageRequestedInfoError: requestedInfoErrorParameter field must not be null");
        }
        try {
            aos.writeIntegerData(this.requestedInfoErrorParameter.getCode());
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CAPErrorMessageRequestedInfoError: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.requestedInfoErrorParameter != null) {
            sb.append("requestedInfoErrorParameter=");
            sb.append((Object)this.requestedInfoErrorParameter);
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

