/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    TreeBuilder() {
    }

    protected void initialiseParse(String input2, String baseUri, ParseErrorList errors) {
        Validate.notNull(input2, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input2);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new ArrayList(32);
        this.baseUri = baseUri;
    }

    Document parse(String input2, String baseUri) {
        return this.parse(input2, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input2, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input2, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String name) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(this.start.reset().name(name));
    }

    public boolean processStartTag(String name, Attributes attrs) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        this.start.reset();
        this.start.nameAttr(name, attrs);
        return this.process(this.start);
    }

    protected boolean processEndTag(String name) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        return this.process(this.end.reset().name(name));
    }

    protected Element currentElement() {
        int size2 = this.stack.size();
        return size2 > 0 ? this.stack.get(size2 - 1) : null;
    }
}

