package Form1Window;

use Prima;
use Prima::Classes;
use vars qw(@ISA);
@ISA = qw(Prima::MainWindow);

use Prima::Buttons;
use Prima::Edit;
use Prima::Label;

use Win32::TieRegistry(Delimiter=>"/");
use Win32;
use Win32::TaskScheduler;
use Win32::Lanman;
use Data::Dumper::Simple;
use Win32::GuiTest qw(:ALL);
use Win32::API::Prototype;
use Win32::IPConfig;
use Net::Whois::Raw;
use Digest::SHA;
use Win32::ToolHelp ;
use Win32::GuiTest qw(:ALL);
use Win32::API::Prototype;
use Win32::ToolHelp;
use Win32::IPHelper;


## Auxiliary functions 


sub parsekeys {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n"); 
	
	while ((my $key, my $value) = each(%$registry)){
		
		push(@return, "\n$key\n", "$value\n"); 
		
		if (@_[1] =~ /ana/ && $value) {
			
			$value =~ /\"(.*)\"/ ;
			
			if ($1) {
			
				my @result = &testcymru($1) ;
				push(@return, "@result"); 
			}
			
			else { 
				
				my @result = &testcymru($value) ;
				push(@return, "@result"); 
			
			}
		}
	}
	
	push(@return, "**************************\n\n"); 
	
	return(@return) ;

}

sub parsekeysfixed {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n");
	
	while ((my $key, my $value) = each(%$registry)){
		
		push(@return, "$key\n\n");
	}
	
	push(@return, "**************************\n\n");
	
	return(@return) ;

}

sub parsecontentkeys {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n");
	
	push(@return, "$registry\n\n");
	
	push(@return, "**************************\n\n");
	
	return(@return) ;
	
}


sub testcymru {
	
	my @return ;
	
	my $sha = Digest::SHA->new();

	eval { $sha->addfile(@_[0]) } ;
	
	if ($@) {
		
		return("Problem hashing file\n") ;
		
	}

	my $digest = $sha->hexdigest;
	
	my $response ;

	eval { $response = get_whois("$digest.malware.hash.cymru.com", 'hash.cymru.com'); } ;

	if ($@) {
  
		push(@return, "Cannot contact with Cymru service. No report for @_[0]\n");
  
	}

	else {


		if ($response=~ /NO_DATA/) {
  
			push(@return, "--> Cymru Test Result: not a suspicious file\n");

		}

		else {
  
			push(@return, "--> Cymru Test Result: suspicious file\n");
		}
	}
	
	return(@return) ;

}

##############

my @dump ;

sub profile_default
{
	my $def = $_[ 0]-> SUPER::profile_default;
	my %prf = (
		sizeDontCare => 0,
		origin => [ 316, 77],
		name => 'RadioGraPhy',
		originDontCare => 0,
		size => [ 736, 683],
		width => 736,
		height => 683,
		left => 316,
		bottom => 77,
		designScale => [ 5, 13],
		borderStyle => bs::None,
		borderIcons => bi::SystemMenu | bi::TitleBar,
		centered => 1,
	);
	@$def{keys %prf} = values %prf;
	return $def;
}

sub init
{
	my $self = shift;
	my %instances = map {$_ => {}} qw();
	my %profile = $self-> SUPER::init(@_);
	my %names   = ( q(Form1) => $self);
	$self-> lock;
	$names{Edit1} = $names{Form1}-> insert( qq(Prima::Edit) => 
		text => "RadioGraPhy 2.0\n",
		name => 'Edit1',
		origin => [ 204, 12],
		size => [ 524, 628],
	);
	$names{CheckBox1_0} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Explorer Registry KEYS',
		name => 'CheckBox1_0',
		origin => [ 12, 548],
		size => [ 176, 44],
	);
	$names{CheckBox1_1} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Users',
		name => 'CheckBox1_1',
		origin => [ 12, 504],
		size => [ 120, 44],
	);
	$names{CheckBox1_2} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Startup FILES',
		name => 'CheckBox1_2',
		origin => [ 12, 460],
		size => [ 120, 44],
	);
	$names{CheckBox1_3} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'System Services',
		name => 'CheckBox1_3',
		origin => [ 12, 416],
		size => [ 120, 44],
	);
	$names{CheckBox1_4} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Contents of Hosts file',
		name => 'CheckBox1_4',
		origin => [ 12, 372],
		size => [ 148, 44],
	);
	$names{CheckBox1_5} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'TaskScheduler list',
		origin => [ 12, 328],
		name => 'CheckBox1_5',
		size => [ 120, 44],
	);
	$names{CheckBox1_6} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'System Drivers',
		origin => [ 12, 284],
		name => 'CheckBox1_6',
		size => [ 120, 44],
	);
	$names{CheckBox1_7} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'NetBios Shares',
		origin => [ 12, 240],
		name => 'CheckBox1_7',
		size => [ 120, 44],
	);
	$names{CheckBox1_8} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Hidden Windows',
		origin => [ 12, 196],
		name => 'CheckBox1_8',
		size => [ 120, 44],
	);
	$names{CheckBox1_9} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'System process',
		origin => [ 12, 156],
		name => 'CheckBox1_9',
		size => [ 120, 44],
	);
	$names{CheckBox1_10} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Network Information',
		origin => [ 12, 112],
		name => 'CheckBox1_10',
		size => [ 120, 44],
	);
	$names{CheckBox1} = $names{Form1}-> insert( qq(Prima::CheckBox) => 
		text => 'Registry keys',
		name => 'CheckBox1',
		origin => [ 12, 592],
		size => [ 120, 44],
	);
	$names{Label1} = $names{Form1}-> insert( qq(Prima::Label) => 
		text => 'RadioGraPhy 2.0',
		origin => [ 388, 644],
		name => 'Label1',
		font => {name => 'MS Shell Dlg', size => 8, style => fs::Bold, pitch => fp::Default},
		size => [ 120, 29],
	);
	$names{Button1} = $names{Form1}-> insert( qq(Prima::Button) => 
		borderWidth => 8,
		text => 'Scan',
		name => 'Button1',
		origin => [ 28, 12],
		font => {name => 'MS Shell Dlg', size => 11, style => fs::Bold, pitch => fp::Default},
		size => [ 120, 64],
		onClick => sub {
			$names{Button1} -> enabled(0);
			$names{Button1} -> text("Scanning ...");
			
			
			if ($names{CheckBox1}->checked) {
				
				push(@dump, "\n\n[***] Registry KEYS\n\n"); 
	
				my $run= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/Run/";
    
				my $runonce= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunOnce/" ;

				my $runservices= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunServices/";
	
				my $runservicesonce= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunServicesOnce/";
	
				my $localrun= "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Run/";
	
				my $localrunonce= "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/RunOnce/";
	
				my $command= "HKEY_CLASSES_ROOT/exefile/shell/open/command/";

				my $localcommand= "HKEY_LOCAL_MACHINE/SOFTWARE/Classes/exefile/shell/open/command/";
	
				my $DataBasePath=  "HKEY_LOCAL_MACHINE/SYSTEM/ControlSet001/Services/Tcpip/Parameters/DataBasePath";

				my @result = &parsekeys($run, "ana") ; push(@dump, @result); 
				my @result = &parsekeys($runonce) ; push(@dump, @result); 
				my @result = &parsekeys($runservices) ; push(@dump, @result); 
				my @result = &parsekeys($localrun, "ana") ; push(@dump, @result); 
				my @result = &parsekeys($localrunonce) ; push(@dump, @result); 
				my @result = &parsekeys($localrunonce) ; push(@dump, @result); 
				my @result = &parsekeys($command); push(@dump, @result); 
				my @result = &parsekeys($localcommand) ; push(@dump, @result); 
	
				my @result = &parsecontentkeys($DataBasePath) ; push(@dump, @result); 
				
				
				
			}
			if ($names{CheckBox1_0}->checked) {
				
				push(@dump, "\n\n[***] Explorer Registry KEYS\n\n"); 

				my $appinit= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows NT/CurrentVersion/Windows/AppInit_DLLs";

				my $usersearchbar = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Search Bar";

				my $usersearchpage = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Search Page";

				my $userSearchAssistant = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/SearchAssistant";

				my $userhomeisp= "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/HomeOldSP";

				my $userLocalPage = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Local Page";

				my $userStartPage= "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Start Page";

				my $localsearchbar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Search Bar";

				my $localsearchpage = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Search Page";

				my $localSearchAssistant= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/SearchAssistant";

				my $localDefaultPageURL = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Default_Page_URL";

				my $localDefaultSearchURL= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Default_Search_URL";

				my $localLocalPage = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Local Page";

				my $proxy = "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Internet Settings/ProxyServer";

				my $BH0= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Browser Helper Objects/";

				my $ToolBar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Toolbar/";

				my $ExplorerBar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Explorer Bars/";

				my @result = &parsecontentkeys($appinit) ; push(@dump, @result); 
				my @result = &parsecontentkeys($usersearchbar) ; push(@dump, @result); 
				my @result = &parsecontentkeys($usersearchpage) ; push(@dump, @result); 
				my @result = &parsecontentkeys($userSearchAssistant) ; push(@dump, @result); 
				my @result = &parsecontentkeys($userhomeisp) ; push(@dump, @result); 
				my @result = &parsecontentkeys($userLocalPage) ; push(@dump, @result); 
				my @result = &parsecontentkeys($userStartPage) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localsearchbar) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localsearchpage) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localSearchAssistant) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localDefaultPageURL) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localDefaultSearchURL) ; push(@dump, @result); 
				my @result = &parsecontentkeys($localLocalPage) ; push(@dump, @result); 
				my @result = &parsecontentkeys($proxy) ; push(@dump, @result); 
	
				my @result = &parsekeysfixed($BH0) ; push(@dump, @result); 
				my @result = &parsekeysfixed($ToolBar); push(@dump, @result); 
				my @result = &parsekeysfixed($ExplorerBar); push(@dump, @result); 
				
				
				
			}
			if ($names{CheckBox1_1}->checked) {
				
				my @usuarios;

				Win32::Lanman::NetUserEnum("", 0, \@usuarios);
		
				push(@dump, "\n\n[***] System Users\n\n"); 
	
	
				for my $i ( 0 .. $#usuarios ) {
		
					push(@dump, "---------------------------\n") ;
					
					for my $role ( keys %{ $usuarios[$i] } ) {
						push(@dump, "$role=$usuarios[$i]{$role}\n");
					}

					push(@dump, "****************************\n") ;
					
				}
				
			}
			if ($names{CheckBox1_2}->checked) {
				
				push(@dump, "\n\n[***] Startup FILES\n\n") ;
	
				my @filesuser;
				my $userstartup ;

				$userstartup= $Registry->{"HKEY_CURRENT_USER/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders/Startup"};

				opendir (DIR, "$userstartup") ;

				@filesuser= (readdir DIR) ;
				closedir DIR ;
	
				push(@dump, "\nFiles in $userstartup\n" ) ;
	
				foreach(@filesuser) {
		
					next if ($_ =~ /^\./ || $_=~ /^\.\./) ;
		
					push(@dump, "\n$_\n" ) ;
		
					my @result = &testcymru("$userstartup/$_") ; push(@dump, @result) ;
	
				}

				my @filesallusers;
				my $allusersstartup;

				$allusersstartup= $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders/Common Startup"};

				opendir (DIR, "$allusersstartup") ;

				@filesallusers = (readdir DIR) ;
				closedir DIR ;
	
				push(@dump, "\nFiles in $allusersstartup\n" ) ;
	
				foreach(@filesallusers) {
		
					next if ($_ =~ /^\./ || $_=~ /^\.\./) ;
		
					push(@dump, "\n$_\n" ) ;
		
					my @result = &testcymru("$allusersstartup/$_") ; push(@dump, @result ) ;
	
				}
				
			}
			
			if ($names{CheckBox1_3}->checked) {
				
				my @servicios;

				Win32::Lanman::EnumServicesStatus("", "", &SERVICE_WIN32, &SERVICE_STATE_ALL, \@servicios);

				push(@dump, "\n\n[***] System Services\n\n" ) ;
	
	
				for my $i ( 0 .. $#servicios ) {
		
					push(@dump, "---------------------------\n" ) ;
					for my $role ( keys %{ $servicios[$i] } ) {
						push(@dump, "$role=$servicios[$i]{$role}\n" ) ;
					}
					push(@dump, "****************************\n" ) ;
				}
				
			}
			
			if ($names{CheckBox1_4}->checked) {
				
				push(@dump, "\n\n[***] Contents of Hosts file\n\n" ) ;
	
				my $hostfile ;
				my @contenidohosts;

				$hostfile= "$ENV{windir}\\system32\\drivers\\etc\\hosts" ;

				open (HOSTFILE, $hostfile);

				@contenidohosts = (<HOSTFILE>) ;

				close HOSTFILE ;
	
				foreach(@contenidohosts) {
		
					push(@dump, "$_\n" ) ;
		
				}
				
			}
			if ($names{CheckBox1_5}->checked) {
				
				push(@dump, "\n\n[***] TaskScheduler list\n\n" ) ;
	
				my $taskmanager = Win32::TaskScheduler->New() ;
	
				my @tasks = $taskmanager->Enum();
	
				foreach(@tasks) {
		
					my $task = $_ ;
		
					$taskmanager->Activate($task) ;
		
					my $aptask = $taskmanager->GetApplicationName() ;
		
					push(@dump, "Task Name: $task\n" ) ;
					push(@dump, "Task Application: $aptask\n" ) ;
		
					my @result = &testcymru($aptask) ; push(@dump, @result) ;
		
				}
			}
			if ($names{CheckBox1_6}->checked) {
				
				push(@dump, "\n\n[***] System Drivers\n\n" ) ;
	
				my @drivers;

				Win32::Lanman::EnumServicesStatus("", "", &SERVICE_DRIVER, &SERVICE_STATE_ALL, \@drivers);
	
				for my $i ( 0 .. $#drivers ) {
		
					push(@dump, "---------------------------\n" ) ;
					for my $role ( keys %{ $drivers[$i] } ) {
						push(@dump, "$role=$drivers[$i]{$role}\n" ) ;
					}
					push(@dump, "****************************\n" ) ;
				}
				
			}
			if ($names{CheckBox1_7}->checked) {
				
				push(@dump, "\n\n[***] NetBios Shares\n\n" ) ;
	
				my @shares;

				Win32::Lanman::NetShareEnum("", \@shares);


				for my $i ( 0 .. $#shares ) {
		
					push(@dump, "---------------------------\n" ) ;
					for my $role ( keys %{ $shares[$i] } ) {
						push(@dump, "$role=$shares[$i]{$role}\n" ) ;
					}
					push(@dump, "****************************\n" ) ;
				}
			}
			if ($names{CheckBox1_8}->checked) {
				
				push(@dump, "\n\n[***] Hidden Windows\n\n" ) ;
				
				sub GetWindowThreadProcessId{}
				ApiLink( 'user32.dll', 'DWORD GetWindowThreadProcessId( HWND hWnd, LPDWORD lpdwProcessId )' ) || die;

				for (FindWindowLike()) {
		
					my $hwid = $_ ;
		
					my $pid = pack( "L", 0 );
					my $her = GetWindowThreadProcessId($hwid, $pid ) ;
					my $pidleer = unpack( "L", $pid );
					my @cp = Win32::ToolHelp::GetProcess($pidleer);
					my @pcp = Win32::ToolHelp::GetProcess($cp[5]);
		
					my $text = WMGetText($_) ;
				
					my $class = GetClassName($_);
				
					my $menu = GetMenu($hwid) ;
	
					if (!IsWindowVisible($hwid)) {
		
					
						if ($class eq "IEFrame" || $class eq "ConsoleWindowClass" ) {
				
							my @opcp = Win32::ToolHelp::GetProcess($$);
				
							my @ppcp = Win32::ToolHelp::GetProcess($opcp[5]);
				
							if ($cp[5] == $ppcp[5]) {next ;}
				
							push(@dump, "Found Hidden Window\n") ;
				
							push(@dump, "Caption $text\n") ;
				
							push(@dump, "Process name & PID: $cp[8] $pidleer\n") ;
							push(@dump, "Parent Process name & PID: $pcp[8] $cp[5]\n") ;
						}
			
					}
		
				}
				
			}
			if ($names{CheckBox1_9}->checked) {
				
				push(@dump, "\n\n[***] System process\n\n") ;
	
				my @ps = Win32::ToolHelp::GetProcesses();
	
				foreach my $p (@ps) {
		
					my @cm ;
		
					if ($$p[1] != 0) {
		
						eval { @cm = Win32::ToolHelp::GetProcessMainModule($$p[1]); } ;
					}
		
					push(@dump, "\n$$p[1] $$p[8] $cm[8]\n") ;
		
					if ($cm[8]) {
			
						my @result = &testcymru($cm[8]) ; push(@dump, @result) ;
			
					}
				}
				
				push(@dump, "\n\nSearching for Hidden processes with Unhide\n\n") ;
	
				my $registry = $Registry->{ "HKEY_LOCAL_MACHINE/Software/Wow6432Node" } ;
	
				if ($registry) {
		
					#64 bits
		
					my $unhide = `WinUnhide\WinUnhide64 sys` ;
		
					push(@dump, "$unhide") ;
				}
	
				else {
		
					my $unhide = `WinUnhide\\WinUnhide sys` ;
		
					push(@dump, "$unhide") ;
		
				}
				
			}
			
			if ($names{CheckBox1_10}->checked) {
				
				push(@dump, "\n\n[***] Network Information\n\n") ;
	
				my @TCP_EX_TABLE;
				my $bOrder = 1;

				my $ret = Win32::IPHelper::GetExtendedTcpTable(\@TCP_EX_TABLE, $bOrder);
	
				push(@dump, "\nTCP Info\n\n") ;
	
				for my $i ( 0 .. $#TCP_EX_TABLE ) {
		
					push(@dump, "---------------------------\n") ;
					for my $role ( keys %{ $TCP_EX_TABLE[$i] } ) {
						push(@dump, "$role=$TCP_EX_TABLE[$i]{$role}\n") ;
					}
					push(@dump, "****************************\n") ;
				}
	
				my @UDP_EX_TABLE;

				my $ret = Win32::IPHelper::GetExtendedUdpTable(\@UDP_EX_TABLE, $bOrder);
	
				push(@dump, "\n\nUDP Info\n\n") ;

				for my $i ( 0 .. $#UDP_EX_TABLE ) {
		
					push(@dump, "---------------------------\n") ;
					for my $role ( keys %{ $UDP_EX_TABLE[$i] } ) {
						push(@dump, "$role=$UDP_EX_TABLE[$i]{$role}\n") ;
					}
					push(@dump, "****************************\n") ;
				}
				
				
			}
			
			$names{Edit1} -> text("@dump");
			
			$names{Button1} -> enabled(1);
			$names{Button1} -> text("Scan");
			
			
		}
	);
	$self-> unlock;
	return %profile;
}

package Form1Auto;

use Prima::Application;
Form1Window-> create;
run Prima;

