#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# keyring
from lazagne.softwares.wallet.kde import Kde
from lazagne.softwares.wallet.libsecret import Libsecret
# browsers
from lazagne.softwares.browsers.mozilla import firefox_browsers
from lazagne.softwares.browsers.opera import Opera
from lazagne.softwares.browsers.chrome import Chrome
# sysadmin
from lazagne.softwares.sysadmin.filezilla import Filezilla
from lazagne.softwares.sysadmin.fstab import Fstab
from lazagne.softwares.sysadmin.env_variable import Env_variable
from lazagne.softwares.sysadmin.shadow import Shadow
from lazagne.softwares.sysadmin.aws import Aws
from lazagne.softwares.sysadmin.ssh import Ssh
from lazagne.softwares.sysadmin.docker import Docker
from lazagne.softwares.sysadmin.cli import Cli
# chats
from lazagne.softwares.chats.pidgin import Pidgin
# mails
from lazagne.softwares.mails.clawsmail import ClawsMail
from lazagne.softwares.mails.thunderbird import Thunderbird
# wifi
from lazagne.softwares.wifi.wifi import Wifi
from lazagne.softwares.wifi.wpa_supplicant import Wpa_supplicant
# databases
from lazagne.softwares.databases.squirrel import Squirrel
from lazagne.softwares.databases.dbvis import DbVisualizer
from lazagne.softwares.databases.sqldeveloper import SQLDeveloper

# memory
from lazagne.softwares.memory.mimipy import Mimipy
try:
    from lazagne.softwares.memory.memorydump import MemoryDump
except ImportError:
    pass


def get_categories():
    category = {
        'chats': {'help': 'Chat clients supported'},
        'sysadmin': {'help': 'SCP/SSH/FTP/FTPS clients supported'},
        'databases': {'help': 'SQL clients supported'},
        'mails': {'help': 'Email clients supported'},
        'memory': {'help': 'Retrieve passwords from memory'},
        'wifi': {'help': 'Wifi'},
        'browsers': {'help': 'Web browsers supported'},
        'wallet': {'help': 'Windows credentials (credential manager, etc.)'}
    }
    return category


def get_modules():
    module_names = [
        ClawsMail(),
        Thunderbird(),
        DbVisualizer(),
        Env_variable(),
        Filezilla(),
        Fstab(),
        # Mozilla(),
        Opera(),
        Chrome(),
        Pidgin(),
        Shadow(),
        Aws(),
        Docker(),
        Ssh(),
        Cli(),
        SQLDeveloper(),
        Squirrel(),
        Wifi(),
        Wpa_supplicant(),
        Kde(),
        Libsecret(), 
        Mimipy()
    ]

    # very long to execute
    # try:
    # 	module_names.append(MemoryDump())
    # except:
    # 	pass

    return module_names + firefox_browsers
