/***************************************************************************
 *   Nipper - The network infrastructure parser                            *
 *   Copyright (C) 2006 - 2008 by Ian Ventura-Whiting                      *
 *   fizz@titania.co.uk                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version. However, there are a number of    *
 *   exceptions listed below.                                              *
 *                                                                         *
 *   EXCEPTIONS TO THE GPL License:                                        *
 *      1. This code cannot be used as part of a commercial product. If a  *
 *         commercial license is required, contact fizz@titania.co.uk for  *
 *         licensing information.                                          *
 *      2. Any code that integrates Nipper MUST display the copyright      *
 *         information below with the programs own copyright information.  *
 *                                                                         *
 *         "Nipper Copyright (C) 2006 - 2008 by Ian Ventura-Whiting"       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/


void pixSNMPConfig(struct nipperConfig *nipper)
{
	// Variables...
	struct snmpPIXHost *snmpHostPIXPointer = 0;
	struct snmpTrapPIX *trapPIXPointer = 0;

	output_parseText(settings_snmp_desc, nipper, section_none, rate_none, -1, 0);
	output_table(nipper, true, settings_snmp_table, &settings_general_heading);
	if (nipper->pix->snmp->enabled == true)
		fprintf(nipper->reportFile, "%sSNMP Server%sEnabled%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->tablerow_end);
	else
		fprintf(nipper->reportFile, "%sSNMP Server%sDisabled%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->tablerow_end);
	fprintf(nipper->reportFile, "%sUDP Port%s%d%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->pix->snmp->port, nipper->tablerow_end);
	if (nipper->passwords == true)
		fprintf(nipper->reportFile, "%sCommunity String%s%s%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->pix->snmp->community, nipper->tablerow_end);
	fprintf(nipper->reportFile, "%sContact%s%s%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->pix->snmp->contact, nipper->tablerow_end);
	fprintf(nipper->reportFile, "%sLocation%s%s%s", nipper->tablerow_start, nipper->tablerow_mid, nipper->pix->snmp->location, nipper->tablerow_end);
	output_table(nipper, false, settings_snmp_table, &settings_snmpPIXhosts_heading);
	if (nipper->pix->snmp->host != 0)
	{
		output_table(nipper, true, settings_snmphost_table, &settings_snmpPIXhosts_heading);
		snmpHostPIXPointer = nipper->pix->snmp->host;
		while (snmpHostPIXPointer != 0)
		{
			fprintf(nipper->reportFile, "%s%s%s", nipper->tablerow_start, snmpHostPIXPointer->interface, nipper->tablerow_mid);
			fprintf(nipper->reportFile, "%s%s", snmpHostPIXPointer->address, nipper->tablerow_mid);
			if (nipper->passwords == true)
				fprintf(nipper->reportFile, "%s%s", snmpHostPIXPointer->community, nipper->tablerow_mid);
			if (snmpHostPIXPointer->version == 0)
				fprintf(nipper->reportFile, "1 and 2c%s", nipper->tablerow_mid);
			else if (snmpHostPIXPointer->version == 1)
				fprintf(nipper->reportFile, "1%s", nipper->tablerow_mid);
			else
				fprintf(nipper->reportFile, "2c%s", nipper->tablerow_mid);
			fprintf(nipper->reportFile, "%d%s", snmpHostPIXPointer->port, nipper->tablerow_mid);
			if (snmpHostPIXPointer->mode == snmp_mode_both)
				fprintf(nipper->reportFile, "Poll and Trap%s", nipper->tablerow_end);
			else if (snmpHostPIXPointer->mode == snmp_mode_poll)
				fprintf(nipper->reportFile, "Poll%s", nipper->tablerow_end);
			else
				fprintf(nipper->reportFile, "Trap%s", nipper->tablerow_end);
			snmpHostPIXPointer = snmpHostPIXPointer->next;
		}
		output_table(nipper, false, settings_snmphost_table, &settings_snmpPIXhosts_heading);
	}
	if (nipper->pix->snmp->trap != 0)
	{
		output_table(nipper, true, settings_snmptrap_table, &settings_snmpPIXtraps_heading);
		trapPIXPointer = nipper->pix->snmp->trap;
		while (trapPIXPointer != 0)
		{
			fprintf(nipper->reportFile, "%s%s%s%s %s", nipper->tablerow_start, trapPIXPointer->section, nipper->tablerow_mid, trapPIXPointer->trap, nipper->tablerow_end);
			trapPIXPointer = trapPIXPointer->next;
		}
		output_table(nipper, false, settings_snmptrap_table, &settings_snmpPIXtraps_heading);
	}
}


void pixSNMPIssue(struct nipperConfig *nipper)
{
	output_parseText(report_snmp_pix_obs, nipper, section_obs, rate_med, nipper->snmpIssue, 0);
	output_endsection(nipper, section_obs);
	output_parseText(report_snmp_impact, nipper, section_imp, rate_med, 0, 0);
	output_endsection(nipper, section_imp);
	output_parseText(report_snmp_ease, nipper, section_ease, rate_difficult, 0, 0);
	output_endsection(nipper, section_ease);
	if (nipper->pix->snmp == 0)
		output_parseText(report_snmp_pix_rec, nipper, section_obs, rate_none, 0, nipper->tableNum);
	else if (nipper->pix->snmp->enabled == false)
		output_parseText(report_snmp_pix2_rec, nipper, section_obs, rate_none, 0, nipper->tableNum);
	else if (nipper->pix->snmp->host != 0)
		output_parseText(report_snmp_pix_rec, nipper, section_obs, rate_none, -1, nipper->tableNum);
	else
		output_parseText(report_snmp_pix_rec, nipper, section_obs, rate_none, 0, nipper->tableNum);
	output_endsection(nipper, section_rec);
}

