/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import gnu.getopt.Getopt;
import java.io.IOException;
import net.cqure.AddressList;
import net.cqure.AddressRange;
import net.cqure.IAddressPool;
import net.cqure.MSSQLOptions;
import net.cqure.MetaData;
import net.cqure.ShutdownThread;
import net.cqure.SimpleLogger;
import net.cqure.ThreadManager;
import net.cqure.exception.InvalidAddressException;
import net.cqure.storage.FileStorage;
import net.cqure.storage.StorageInterface;
import net.cqure.storage.StorageVector;

public class MSSQLScan {
    private static int m_nMaxThreads = 50;
    private static int m_nTimeOut = 500;
    private static SimpleLogger oLogger = SimpleLogger.getInstance();
    private static String _target = null;
    public static boolean _finnished = false;

    private static void usage() {
        System.out.println(String.valueOf(MetaData.getProgramName()) + " -t <target_ip> [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("    -t <target>  \t- target ip address(es)");
        System.out.println("    -l <targetfile>\t- file with target ip adresses");
        System.out.println("    -s <src>    \t- source ip address");
        System.out.println("    -T <threads> \t- maximum threads (default " + m_nMaxThreads + ")");
        System.out.println("    -v           \t- verbose logging");
        System.out.println("    -w <timeout> \t- timeout for replies (default " + m_nTimeOut + " ms)");
        System.out.println("    -o <file>    \t- output to file");
        System.out.println();
        System.out.println("example:");
        System.out.println("  " + MetaData.getProgramName() + " -t 192.168.1-2.* -o results.txt");
        System.out.println();
    }

    public static void printResults() {
        String strHeader = "Scan results for " + _target;
        System.out.println(strHeader);
        int i = 0;
        while (i < strHeader.length()) {
            System.out.print("-");
            ++i;
        }
        System.out.println("");
        ((StorageInterface)MSSQLOptions.getInstance().get("storage")).printMSSQLInstances();
    }

    public static void main(String[] args) {
        String reportFile = null;
        Getopt opt = new Getopt(MetaData.getProgramName(), args, "hvt:s:T:w:S:o:l:");
        int c = -1;
        String listFilename = null;
        IAddressPool addressPool = null;
        System.out.println();
        System.out.print(MetaData.getBanner());
        while ((c = opt.getopt()) != -1) {
            switch (c) {
                case 108: {
                    listFilename = opt.getOptarg();
                    break;
                }
                case 104: {
                    MSSQLScan.usage();
                    System.exit(1);
                }
                case 116: {
                    _target = opt.getOptarg();
                    break;
                }
                case 84: {
                    m_nMaxThreads = Integer.parseInt(opt.getOptarg());
                    break;
                }
                case 115: {
                    MSSQLOptions.getInstance().put("source", opt.getOptarg());
                    break;
                }
                case 119: {
                    MSSQLOptions.getInstance().put("timeout", opt.getOptarg());
                    break;
                }
                case 118: {
                    oLogger.setLogDebug();
                    break;
                }
                case 83: {
                    break;
                }
                case 111: {
                    reportFile = opt.getOptarg();
                    break;
                }
                default: {
                    System.exit(1);
                }
            }
        }
        if (_target != null && listFilename != null) {
            System.err.println("Target and listfile options are mutually exclusive");
            System.exit(-1);
        }
        if (_target == null && listFilename == null) {
            MSSQLScan.usage();
            System.exit(-1);
        } else if (listFilename != null) {
            try {
                addressPool = new AddressList(listFilename);
                MSSQLOptions.getInstance().put("targets", addressPool);
            }
            catch (Exception e) {
                System.err.println("Failed to load addresslist from: " + listFilename);
                System.err.println("The error reported was: " + e.getLocalizedMessage());
                System.exit(1);
            }
        } else {
            try {
                addressPool = new AddressRange(_target);
                MSSQLOptions.getInstance().put("targets", addressPool);
            }
            catch (InvalidAddressException e1) {
                System.err.println("ERROR: An invalid address range was specified: " + _target);
                System.exit(1);
            }
        }
        if (MSSQLOptions.getInstance().get("timeout") == null) {
            MSSQLOptions.getInstance().put("timeout", String.valueOf(m_nTimeOut));
        }
        if (reportFile != null) {
            try {
                MSSQLOptions.getInstance().put("storage", new FileStorage(reportFile));
            }
            catch (IOException e) {
                oLogger.logError("failed to create report: " + reportFile);
                System.exit(1);
            }
        }
        if (MSSQLOptions.getInstance().get("storage") == null) {
            MSSQLOptions.getInstance().put("storage", new StorageVector());
        }
        if (_target != null) {
            oLogger.logInfo("Starting scan of " + _target + " ...");
        } else {
            oLogger.logInfo("Starting scan, reading targets from: " + listFilename);
        }
        ThreadManager manager = new ThreadManager(m_nMaxThreads);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(manager));
        try {
            manager.startScan();
            manager.waitForRunningThreads();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        SimpleLogger.getInstance().logInfo("Finnished scanning...");
        _finnished = true;
    }
}

