#ifndef MOBIUS_CRYPT_HASH_ED2K_H
#define MOBIUS_CRYPT_HASH_ED2K_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/hash_block.h>
#include <mobius/crypt/hash_md4.h>
#include <cstdint>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief ED2K hash function implementation
//! \author Eduardo Aguiar
//! \see https://en.wikipedia.org/wiki/EDonkey_network
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class hash_ed2k : public hash_block
{
public:
  hash_ed2k () noexcept;

private:
  void _update_block (const mobius::bytearray&) noexcept final;
  void _reset () noexcept final;
  mobius::bytearray _evaluate (const mobius::bytearray&) final;

private:

  //! \brief accumulated MD4 hash of MD4 hashes
  hash_md4 md4_accum_;
  
  //! \brief current MD4 hash
  hash_md4 md4_;

  //! \brief number of 512 bit blocks processed
  std::uint64_t blocks_ = 0;
};

} // namespace crypt
} // namespace mobius

#endif
