/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import rcm.awt.Constrain;
import websphinx.workbench.Context;
import websphinx.workbench.ScriptInterpreter;

class PageFeatureArgs
extends Panel {
    TextField urlPattern;
    TextField urlNegPattern;
    TextField textPattern;
    TextField textNegPattern;
    TextField htmlPattern;
    TextField htmlNegPattern;
    TextField titlePattern;
    TextField titleNegPattern;
    TextField labels;
    Choice orTerms;
    TextArea script;
    static final String ANY_TERMS = "any";
    static final String ALL_TERMS = "all";

    public PageFeatureArgs() {
        this.setLayout(new CardLayout());
        Panel panel = new Panel();
        this.add("all pages", panel);
        panel = Constrain.makeConstrainedPanel(1, 4);
        this.add("URL", panel);
        Constrain.add(panel, new Label(" matches the wildcard expression "), Constrain.labelLike(0, 0));
        this.urlPattern = new TextField();
        Constrain.add(panel, this.urlPattern, Constrain.fieldLike(0, 1));
        Constrain.add(panel, new Label(" but not the expression "), Constrain.labelLike(0, 2));
        this.urlNegPattern = new TextField();
        Constrain.add(panel, this.urlNegPattern, Constrain.fieldLike(0, 3));
        panel = Constrain.makeConstrainedPanel(1, 4);
        this.add("HTML", panel);
        Constrain.add(panel, new Label(" matches the HTML tag expression "), Constrain.labelLike(0, 0));
        this.htmlPattern = new TextField();
        Constrain.add(panel, this.htmlPattern, Constrain.fieldLike(0, 1));
        Constrain.add(panel, new Label(" but not the expression "), Constrain.labelLike(0, 2));
        this.htmlNegPattern = new TextField();
        Constrain.add(panel, this.htmlNegPattern, Constrain.fieldLike(0, 3));
        panel = Constrain.makeConstrainedPanel(1, 4);
        this.add("text", panel);
        Constrain.add(panel, new Label(" matches the regular expression "), Constrain.labelLike(0, 0));
        this.textPattern = new TextField();
        Constrain.add(panel, this.textPattern, Constrain.fieldLike(0, 1));
        Constrain.add(panel, new Label(" but not the expression "), Constrain.labelLike(0, 2));
        this.textNegPattern = new TextField();
        Constrain.add(panel, this.textNegPattern, Constrain.fieldLike(0, 3));
        panel = Constrain.makeConstrainedPanel(1, 4);
        this.add("title", panel);
        Constrain.add(panel, new Label(" matches the regular expression "), Constrain.labelLike(0, 0));
        this.titlePattern = new TextField();
        Constrain.add(panel, this.titlePattern, Constrain.fieldLike(0, 1));
        Constrain.add(panel, new Label(" but not the expression "), Constrain.labelLike(0, 2));
        this.titleNegPattern = new TextField();
        Constrain.add(panel, this.titleNegPattern, Constrain.fieldLike(0, 3));
        panel = Constrain.makeConstrainedPanel(3, 2);
        this.add("labels", panel);
        Constrain.add(panel, new Label(" include "), Constrain.labelLike(0, 0));
        this.orTerms = new Choice();
        Constrain.add(panel, this.orTerms, Constrain.labelLike(1, 0));
        this.orTerms.addItem(ANY_TERMS);
        this.orTerms.addItem(ALL_TERMS);
        this.orTerms.select(ANY_TERMS);
        Constrain.add(panel, new Label(" of the labels "), Constrain.labelLike(2, 0));
        this.labels = new TextField();
        Constrain.add(panel, this.labels, Constrain.fieldLike(0, 1, 3));
        ScriptInterpreter interp = Context.getScriptInterpreter();
        if (interp != null) {
            panel = Constrain.makeConstrainedPanel(1, 2);
            this.add("script", panel);
            Constrain.add(panel, new Label(interp.getLanguage() + " Function (crawler, page)"), Constrain.labelLike(0, 0));
            this.script = new TextArea("return true;\n");
            Constrain.add(panel, this.script, Constrain.areaLike(0, 1));
        } else {
            panel = Constrain.makeConstrainedPanel(1, 1);
            this.add("script", panel);
            Constrain.add(panel, new Label("No scripting language is available."), Constrain.labelLike(0, 0));
        }
    }

    public void setURLPattern(String pattern) {
        this.urlPattern.setText(pattern);
    }

    public String getURLPattern() {
        return this.urlPattern.getText();
    }

    public void setURLNegPattern(String pattern) {
        this.urlNegPattern.setText(pattern);
    }

    public String getURLNegPattern() {
        return this.urlNegPattern.getText();
    }

    public void setTextPattern(String pattern) {
        this.textPattern.setText(pattern);
    }

    public String getTextPattern() {
        return this.textPattern.getText();
    }

    public void setTextNegPattern(String pattern) {
        this.textNegPattern.setText(pattern);
    }

    public String getTextNegPattern() {
        return this.textNegPattern.getText();
    }

    public void setHTMLPattern(String pattern) {
        this.htmlPattern.setText(pattern);
    }

    public String getHTMLPattern() {
        return this.htmlPattern.getText();
    }

    public void setHTMLNegPattern(String pattern) {
        this.htmlNegPattern.setText(pattern);
    }

    public String getHTMLNegPattern() {
        return this.htmlNegPattern.getText();
    }

    public void setTitlePattern(String pattern) {
        this.titlePattern.setText(pattern);
    }

    public String getTitlePattern() {
        return this.titlePattern.getText();
    }

    public void setTitleNegPattern(String pattern) {
        this.titleNegPattern.setText(pattern);
    }

    public String getTitleNegPattern() {
        return this.titleNegPattern.getText();
    }

    public void setLabels(String pattern) {
        this.labels.setText(pattern);
    }

    public String getLabels() {
        return this.labels.getText();
    }

    public void setOrTerms(boolean orTerms) {
        this.orTerms.select(orTerms ? ANY_TERMS : ALL_TERMS);
    }

    public boolean getOrTerms() {
        return this.orTerms.getSelectedItem().equals(ANY_TERMS);
    }

    public void setScript(String script) {
        this.script.setText(script);
    }

    public String getScript() {
        return this.script != null ? this.script.getText() : null;
    }

    static {
        ANY_TERMS = ANY_TERMS;
        ALL_TERMS = ALL_TERMS;
    }
}

