/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.applet.Applet;
import java.applet.AppletContext;
import java.net.URL;
import java.util.BitSet;
import netscape.javascript.JSObject;
import rcm.util.Str;
import websphinx.workbench.Browser;
import websphinx.workbench.Context;
import websphinx.workbench.ScriptException;
import websphinx.workbench.ScriptInterpreter;

public class Netscape
extends Browser
implements ScriptInterpreter {
    JSObject jsobject;
    BitSet applies = new BitSet();
    static String DBLQUOTE = "\"";
    static String LINEFEED = "\n";
    static String BACKSLASH = "\\";

    public Netscape(AppletContext context) {
        super(context);
        this.init();
    }

    public Netscape(AppletContext context, String frameName) {
        super(context, frameName);
        this.init();
    }

    private void init() {
        try {
            this.jsobject = JSObject.getWindow((Applet)Context.getApplet());
        }
        catch (Throwable e) {
            this.jsobject = null;
        }
    }

    public ScriptInterpreter getScriptInterpreter() {
        return this.jsobject != null ? this : null;
    }

    public String getLanguage() {
        return "Javascript";
    }

    public Object eval(String expression) throws ScriptException {
        if (this.jsobject == null) {
            throw new ScriptException("Javascript not available");
        }
        try {
            return this.jsobject.eval(expression);
        }
        catch (Throwable e) {
            throw new ScriptException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lambda(String[] args, String body) throws ScriptException {
        Object func;
        StringBuffer code = new StringBuffer();
        this.makeApply(args.length);
        code.append("Function (");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                code.append(DBLQUOTE);
                code.append(args[i]);
                code.append(DBLQUOTE + ", ");
                ++i;
            }
        }
        code.append(DBLQUOTE);
        body = Str.replace(body, BACKSLASH, BACKSLASH + BACKSLASH);
        body = Str.replace(body, DBLQUOTE, BACKSLASH + DBLQUOTE);
        body = Str.replace(body, LINEFEED, BACKSLASH + LINEFEED);
        code.append(body);
        code.append(DBLQUOTE + ")");
        System.out.println("evaluating\n" + code + "\n");
        JSObject jSObject = this.jsobject;
        synchronized (jSObject) {
            func = this.eval(code.toString());
        }
        System.out.println("lambda " + func);
        return func;
    }

    void makeApply(int n) {
        if (this.applies.get(n)) {
            return;
        }
        this.applies.set(n);
        StringBuffer app = new StringBuffer();
        app.append("Function ('f', ");
        int i = 0;
        while (i < n) {
            app.append("'a");
            app.append(String.valueOf(i));
            app.append("',");
            ++i;
        }
        app.append("'return f (");
        int i2 = 0;
        while (i2 < n) {
            if (i2 > 0) {
                app.append(',');
            }
            app.append("a");
            app.append(String.valueOf(i2));
            ++i2;
        }
        app.append(")')");
        try {
            this.set("apply" + (n + 1), this.eval(app.toString()));
        }
        catch (ScriptException e) {
            throw new RuntimeException("Internal error: cannot create Javascript apply function:\n" + app.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(Object func, Object[] args) throws ScriptException {
        Object result;
        if (this.jsobject == null) {
            throw new ScriptException("Javascript not available");
        }
        Object[] funcPlusArgs = new Object[1 + args.length];
        funcPlusArgs[0] = func;
        System.arraycopy(args, 0, funcPlusArgs, 1, args.length);
        try {
            JSObject jSObject = this.jsobject;
            synchronized (jSObject) {
                result = this.jsobject.call("apply" + funcPlusArgs.length, funcPlusArgs);
            }
        }
        catch (Throwable e) {
            throw new ScriptException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String name, Object object) {
        if (this.jsobject != null) {
            JSObject jSObject = this.jsobject;
            synchronized (jSObject) {
                this.jsobject.setMember(name, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) {
        if (this.jsobject == null) {
            return null;
        }
        JSObject jSObject = this.jsobject;
        synchronized (jSObject) {
            Object object = this.jsobject.getMember(name);
            return object;
        }
    }

    public void show(URL url) {
        if (this.frameName != null) {
            String code = "window.open ('', '" + this.frameName + "').focus ()";
            try {
                this.eval(code);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        super.show(url);
    }
}

