/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import gd.AllPairsAlgorithm;
import gd.GDAlgorithm;
import graph.Graph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import rcm.awt.MultiLineString;
import websphinx.workbench.GraphLayoutControlPanel;
import websphinx.workbench.RenderedEdge;
import websphinx.workbench.RenderedNode;
import websphinx.workbench.Tipped;

public class GraphLayout
extends Canvas
implements Runnable,
ImageObserver {
    Graph graph;
    double restLength = 50.0;
    double springConstant = 100.0;
    double nodeCharge = 10000.0;
    GDAlgorithm algorithm;
    boolean running = false;
    boolean automaticLayout = true;
    double threshold = 100.0;
    boolean quiescent = true;
    boolean dirty = true;
    int interval = 100;
    int iterations = 3;
    Color nodeColor = Color.pink;
    Color edgeColor = Color.black;
    Color tipColor = Color.yellow;
    Object tipObject = null;
    MultiLineString tip = null;
    int tipX;
    int tipY;
    int tipWidth;
    int tipHeight;
    GraphLayoutControlPanel controlPanel;
    Thread iterator;
    static final int MULTIPLIER = 2;
    double originX = 0.0;
    double originY = 0.0;
    double scaleX = 1.0;
    double scaleY = 1.0;
    Image offscreen;
    Dimension offSize;
    Graphics offg;
    FontMetrics fm;
    RenderedNode dragNode = null;
    int dragOffsetX;
    int dragOffsetY;

    public GraphLayout() {
        this.graph = new Graph();
        this.resetAlgorithm();
        this.start();
    }

    public synchronized void clear() {
        this.graph = new Graph();
        this.changedGraph();
    }

    public synchronized Graph getGraph() {
        return this.graph;
    }

    public synchronized void setGraph(Graph graph) {
        this.graph = graph;
        this.tipObject = null;
        this.tip = null;
        this.changedGraph();
    }

    public synchronized GDAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public synchronized void setAlgorithm(GDAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.changedGraph();
    }

    synchronized void resetAlgorithm() {
        this.algorithm = new AllPairsAlgorithm(this.springConstant, this.nodeCharge);
        this.changedGraph();
    }

    public synchronized double getRestLength() {
        return this.restLength;
    }

    public synchronized void setRestLength(double restLength) {
        this.restLength = restLength;
        this.changedGraph();
    }

    public synchronized double getSpringConstant() {
        return this.springConstant;
    }

    public synchronized void setSpringConstant(double springConstant) {
        this.springConstant = springConstant;
        this.resetAlgorithm();
    }

    public synchronized double getNodeCharge() {
        return this.nodeCharge;
    }

    public synchronized void setNodeCharge(double nodeCharge) {
        this.nodeCharge = nodeCharge;
        this.resetAlgorithm();
    }

    public synchronized int getInterval() {
        return this.interval;
    }

    public synchronized void setInterval(int interval) {
        this.interval = interval;
    }

    public synchronized int getIterations() {
        return this.iterations;
    }

    public synchronized void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public synchronized boolean getAutomaticLayout() {
        return this.automaticLayout;
    }

    public synchronized void setAutomaticLayout(boolean f) {
        this.automaticLayout = f;
        boolean bl = this.quiescent = !this.automaticLayout;
        if (this.controlPanel != null) {
            this.controlPanel.automatic.setState(this.automaticLayout);
        }
    }

    public synchronized boolean getQuiescent() {
        return this.quiescent;
    }

    public synchronized boolean getRunning() {
        return this.running;
    }

    public synchronized double getThreshold() {
        return this.threshold;
    }

    public synchronized void setThreshold(double threshold) {
        this.threshold = threshold;
        this.changedGraph();
    }

    public synchronized Color getNodeColor() {
        return this.nodeColor;
    }

    public synchronized void setNodeColor(Color nodeColor) {
        this.nodeColor = nodeColor;
    }

    public synchronized Color getEdgeColor() {
        return this.edgeColor;
    }

    public synchronized void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public synchronized Color getTipColor() {
        return this.tipColor;
    }

    public synchronized void setTipColor(Color tipColor) {
        this.tipColor = tipColor;
    }

    public synchronized RenderedNode getSelectedNode() {
        return this.tipObject instanceof RenderedNode ? (RenderedNode)this.tipObject : null;
    }

    public synchronized RenderedEdge getSelectedEdge() {
        return this.tipObject instanceof RenderedEdge ? (RenderedEdge)this.tipObject : null;
    }

    public synchronized void addNode(RenderedNode node) {
        this.graph.addNode(node);
        this.graph.placeNode(node, node.x, node.y);
        this.changedGraph();
    }

    public synchronized void addEdge(RenderedEdge edge) {
        if (edge.restLength == 0.0) {
            edge.restLength = this.restLength;
        }
        this.graph.addEdge(edge);
        this.changedGraph();
    }

    public synchronized void removeNode(RenderedNode node) {
        this.graph.removeNode(node);
        this.changedGraph();
    }

    public synchronized void removeEdge(RenderedEdge edge) {
        this.graph.removeEdge(edge);
        this.changedGraph();
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 3) != 0) {
            int i = 0;
            while (i < this.graph.sizeNodes) {
                RenderedNode n = (RenderedNode)this.graph.nodes[i];
                if (n.icon == img) {
                    n.width = width;
                    n.height = height;
                    this.changedGraph();
                }
                ++i;
            }
        }
        return super.imageUpdate(img, infoflags, x, y, width, height);
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            this.iterator = new Thread((Runnable)this, "GraphListener");
            this.iterator.setDaemon(true);
            this.iterator.setPriority(1);
            this.iterator.start();
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.notify();
            this.iterator = null;
        }
    }

    public synchronized void run() {
        this.quiescent = false;
        while (this.running) {
            long start = System.currentTimeMillis();
            if (this.automaticLayout && !this.quiescent) {
                int i = 0;
                while (i < this.iterations) {
                    double improvement = this.algorithm.improveGraph(this.graph);
                    this.dirty = true;
                    if (improvement <= this.threshold * (double)this.graph.sizeNodes) {
                        this.quiescent = true;
                        break;
                    }
                    ++i;
                }
            }
            if (this.dirty) {
                super.repaint();
            }
            try {
                this.wait(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.quiescent = true;
    }

    public synchronized void changedGraph() {
        if (this.automaticLayout) {
            this.quiescent = false;
        }
        this.repaint();
    }

    public synchronized void repaint() {
        if (!this.running) {
            super.repaint();
        } else {
            this.dirty = true;
        }
    }

    public void showControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new GraphLayoutControlPanel(this);
        }
        this.controlPanel.show();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.controlPanel != null) {
            this.controlPanel.dispose();
            this.controlPanel = null;
        }
    }

    private void scaleGraph() {
        Dimension d = this.size();
        double halfScreenWidth = (double)d.width / 2.0;
        double halfScreenHeight = (double)d.height / 2.0;
        double sX = 1.0;
        double sY = 1.0;
        int i = 0;
        while (i < this.graph.sizeNodes) {
            RenderedNode n = (RenderedNode)this.graph.nodes[i];
            sX = Math.min(sX, (halfScreenWidth - (double)n.width / 2.0) / (Math.abs(n.x) + 1.0));
            sY = Math.min(sY, (halfScreenHeight - (double)n.height / 2.0) / (Math.abs(n.y) + 1.0));
            ++i;
        }
        double oX = halfScreenWidth;
        double oY = halfScreenHeight;
        int i2 = 0;
        while (i2 < this.graph.sizeNodes) {
            RenderedNode n = (RenderedNode)this.graph.nodes[i2];
            n.screenX = (int)(n.x * sX + oX);
            n.screenY = (int)(n.y * sY + oY);
            ++i2;
        }
        this.originX = oX;
        this.originY = oY;
        this.scaleX = sX;
        this.scaleY = sY;
    }

    public synchronized void placeNodeOnScreen(RenderedNode n, int x, int y) {
        this.graph.placeNode(n, ((double)x - this.originX) / this.scaleX, ((double)y - this.originY) / this.scaleY);
        n.screenX = x;
        n.screenY = y;
    }

    public synchronized void placeNodeOnGraph(RenderedNode n, double x, double y) {
        this.graph.placeNode(n, x, y);
        n.screenX = (int)(x * this.scaleX + this.originX);
        n.screenY = (int)(y * this.scaleY + this.originY);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void createOffscreenArea(Dimension d) {
        this.offSize = new Dimension(d.width > 0 ? d.width : 1, d.height > 0 ? d.height : 1);
        this.offscreen = this.createImage(this.offSize.width, this.offSize.height);
        this.offg = this.offscreen.getGraphics();
        this.offg.setFont(this.getFont());
        this.fm = this.offg.getFontMetrics();
    }

    public synchronized void paint(Graphics g) {
        Dimension d = this.size();
        if (this.offscreen == null || d.width != this.offSize.width || d.height != this.offSize.height) {
            this.createOffscreenArea(d);
        }
        this.offg.setColor(this.getBackground());
        this.offg.fillRect(0, 0, d.width, d.height);
        this.scaleGraph();
        int i = 0;
        while (i < this.graph.sizeEdges) {
            RenderedEdge e = (RenderedEdge)this.graph.edges[i];
            if (e != null) {
                RenderedNode from = (RenderedNode)e.from;
                RenderedNode to = (RenderedNode)e.to;
                if (from != null && to != null) {
                    Color c = e.color;
                    if (c == null) {
                        c = this.edgeColor;
                    }
                    this.offg.setColor(c);
                    this.drawArrowToBox(this.offg, from.screenX, from.screenY, to.screenX, to.screenY, to.width / 2, to.height / 2, 6, 3, e.thick);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.graph.sizeNodes) {
            RenderedNode n = (RenderedNode)this.graph.nodes[i2];
            if (n != null) {
                int width = n.width;
                int height = n.height;
                int x = n.screenX - width / 2;
                int y = n.screenY - height / 2;
                Color c = n.color;
                if (n.icon == null) {
                    if (c == null) {
                        c = this.nodeColor;
                    }
                    this.offg.setColor(c);
                    this.offg.fillRect(x, y, width, height);
                    this.offg.setColor(this.getForeground());
                    this.offg.drawRect(x, y, width - 1, height - 1);
                    this.offg.drawString(n.name, x + 5, y + 2 + this.fm.getAscent());
                } else if (c == null) {
                    this.offg.drawImage(n.icon, x, y, this);
                } else {
                    this.offg.drawImage(n.icon, x, y, c, this);
                }
            }
            ++i2;
        }
        if (this.tip != null) {
            this.offg.setColor(this.tipColor);
            this.offg.fillRect(this.tipX, this.tipY, this.tipWidth, this.tipHeight);
            this.offg.setColor(Color.black);
            this.offg.drawRect(this.tipX, this.tipY, this.tipWidth - 1, this.tipHeight - 1);
            this.tip.draw(this.offg, this.tipX + 5, this.tipY + 2, 0);
        }
        this.offg.setColor(this.quiescent ? this.getForeground() : Color.red);
        this.offg.drawRect(0, 0, d.width - 1, d.height - 1);
        g.drawImage(this.offscreen, 0, 0, null);
        this.dirty = false;
    }

    void drawArrowToBox(Graphics g, int x1, int y1, int x2, int y2, int wHalfBox, int hHalfBox, int head_length, int head_width, boolean thick) {
        if (thick) {
            this.drawArrowToBox(g, x1, y1, x2, y2, wHalfBox, hHalfBox, head_length, head_width, false);
            this.drawArrowToBox(g, x1 - 1, y1, x2 - 1, y2, wHalfBox, hHalfBox, head_length, head_width, false);
            this.drawArrowToBox(g, x1, y1 - 1, x2, y2 - 1, wHalfBox, hHalfBox, head_length, head_width, false);
            this.drawArrowToBox(g, x1 - 1, y1 - 1, x2 - 1, y2 - 1, wHalfBox, hHalfBox, head_length, head_width, false);
        } else {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double d = Math.sqrt(dx * dx + dy * dy);
            if (d < 1.0) {
                d = 1.0;
                dx = 1.0;
            }
            double lx = (double)head_length * (dx /= d);
            double ly = (double)head_length * (dy /= d);
            double wx = (double)head_width * dx;
            double wy = (double)head_width * dy;
            double cp1 = dx * (double)hHalfBox - dy * (double)wHalfBox;
            double cp2 = dx * (double)hHalfBox + dy * (double)wHalfBox;
            if (cp1 < 0.0) {
                if (cp2 < 0.0) {
                    x2 += wHalfBox;
                    y2 = (int)((double)y2 + (double)wHalfBox * dy / dx);
                } else {
                    y2 -= hHalfBox;
                    x2 = (int)((double)x2 - (double)hHalfBox * dx / dy);
                }
            } else if (cp2 > 0.0) {
                x2 -= wHalfBox;
                y2 = (int)((double)y2 - (double)wHalfBox * dy / dx);
            } else {
                y2 += hHalfBox;
                x2 = (int)((double)x2 + (double)hHalfBox * dx / dy);
            }
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x2, y2, (int)((double)x2 - lx + wy + 0.5), (int)((double)y2 - ly - wx + 0.5));
            g.drawLine(x2, y2, (int)((double)x2 - lx - wy + 0.5), (int)((double)y2 - ly + wx + 0.5));
        }
    }

    public synchronized FontMetrics getFontMetrics() {
        if (this.fm == null) {
            Dimension d = this.size();
            this.createOffscreenArea(d);
        }
        return this.fm;
    }

    public synchronized void setFont(Font f) {
        super.setFont(f);
        if (this.offg != null) {
            this.offg.setFont(f);
            this.fm = this.offg.getFontMetrics();
        }
    }

    void point(int x, int y) {
        Object over = this.pick(x, y);
        if (over == null) {
            if (this.tipObject != null || this.tip != null) {
                this.tipObject = null;
                this.tip = null;
                super.repaint();
            }
        } else if (over != this.tipObject) {
            String[] tipLines = ((Tipped)over).getTip();
            if (tipLines == null) {
                this.tipObject = null;
                this.tip = null;
                super.repaint();
            } else {
                this.tipObject = over;
                this.tip = new MultiLineString(tipLines);
                this.tipWidth = this.tip.getWidth(this.fm) + 10;
                this.tipHeight = this.tip.getHeight(this.fm) + 4;
                this.tipX = Math.max(x - this.tipWidth / 2, 0);
                this.tipY = Math.min(y + 25, this.offSize.height - this.tipHeight);
                super.repaint();
            }
        }
    }

    void leave() {
        if (this.tipObject != null || this.tip != null) {
            this.tip = null;
            this.tipObject = null;
            super.repaint();
        }
    }

    void click(int x, int y, boolean rightClick) {
        this.requestFocus();
        Object over = this.pick(x, y);
        if (over != null) {
            if (over instanceof RenderedNode) {
                RenderedNode n = (RenderedNode)over;
                if (!n.fixed) {
                    this.dragNode = n;
                    this.dragNode.fixed = true;
                    this.dragOffsetX = this.dragNode.screenX - x;
                    this.dragOffsetY = this.dragNode.screenY - y;
                }
            }
        } else if (rightClick) {
            this.showControlPanel();
        }
    }

    void drag(int x, int y) {
        if (this.dragNode != null) {
            this.placeNodeOnScreen(this.dragNode, x + this.dragOffsetX, y + this.dragOffsetY);
            this.changedGraph();
        }
    }

    void drop(int x, int y) {
        if (this.dragNode != null) {
            this.placeNodeOnScreen(this.dragNode, x + this.dragOffsetX, y + this.dragOffsetY);
            this.changedGraph();
            this.dragNode.fixed = false;
            this.dragNode = null;
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                this.click(event.x, event.y, event.metaDown());
                return true;
            }
            case 502: {
                this.drop(event.x, event.y);
                return true;
            }
            case 503: {
                this.point(event.x, event.y);
                return true;
            }
            case 505: {
                this.leave();
                return true;
            }
            case 506: {
                if (this.dragNode != null) {
                    this.drag(event.x, event.y);
                    return true;
                }
                super.handleEvent(event);
            }
        }
        return super.handleEvent(event);
    }

    public Object pick(int x, int y) {
        int i = this.graph.sizeNodes - 1;
        while (i >= 0) {
            RenderedNode n = (RenderedNode)this.graph.nodes[i];
            if (Math.abs(n.screenX - x) < n.width / 2 && Math.abs(n.screenY - y) < n.height / 2) {
                return n;
            }
            --i;
        }
        int i2 = this.graph.sizeEdges - 1;
        while (i2 >= 0) {
            RenderedEdge e = (RenderedEdge)this.graph.edges[i2];
            RenderedNode to = (RenderedNode)e.to;
            RenderedNode from = (RenderedNode)e.from;
            if (this.inLineSegment(x, y, to.screenX, to.screenY, from.screenX, from.screenY, 4)) {
                return e;
            }
            --i2;
        }
        return null;
    }

    boolean inLineSegment(int x, int y, int x1, int y1, int x2, int y2, int threshold) {
        int bottom;
        int top;
        int right;
        int left;
        if (x1 < x2) {
            left = x1;
            right = x2;
        } else {
            left = x2;
            right = x1;
        }
        if (y1 < y2) {
            top = y1;
            bottom = y2;
        } else {
            top = y2;
            bottom = y1;
        }
        if (x < left - threshold || x > right + threshold || y < top - threshold || y > bottom + threshold) {
            return false;
        }
        int a = y1 - y2;
        int b = x2 - x1;
        int c = x1 * y2 - x2 * y1;
        int d = a * x + b * y + c;
        return d * d <= threshold * threshold * (a * a + b * b);
    }

    static {
        MULTIPLIER = 2;
    }
}

