/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Button;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import rcm.awt.Constrain;
import rcm.awt.PopupDialog;
import websphinx.Classifier;
import websphinx.Crawler;

public class ClassifierListEditor
extends Panel {
    List classifierList;
    Button newClassifierButton;
    Button loadClassifierButton;
    Button removeClassifierButton;
    Crawler crawler;
    Classifier[] classifiers;

    public ClassifierListEditor() {
        this.setLayout(new GridBagLayout());
        Constrain.add(this, new Label("Classifiers:"), Constrain.labelLike(0, 0));
        this.classifierList = new List(5, false);
        Constrain.add(this, this.classifierList, Constrain.areaLike(0, 1));
        Panel panel = new Panel();
        Constrain.add(this, panel, Constrain.fieldLike(0, 2));
        this.newClassifierButton = new Button("New...");
        panel.add(this.newClassifierButton);
        this.loadClassifierButton = new Button("Load...");
        panel.add(this.loadClassifierButton);
        this.loadClassifierButton.disable();
        this.removeClassifierButton = new Button("Remove");
        panel.add(this.removeClassifierButton);
        this.removeClassifierButton.disable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        if (event.target == this.classifierList) {
            if (this.classifierList.getSelectedIndex() != -1) {
                this.removeClassifierButton.enable();
                return true;
            } else {
                this.removeClassifierButton.disable();
            }
            return true;
        } else {
            if (event.id != 1001) return super.handleEvent(event);
            if (event.target == this.newClassifierButton) {
                this.newClassifier(null);
                return true;
            } else {
                if (event.target == this.loadClassifierButton) return true;
                if (event.target != this.removeClassifierButton) return super.handleEvent(event);
                this.removeSelectedClassifier();
            }
        }
        return true;
    }

    public void setCrawler(Crawler crawler) {
        this.crawler = crawler;
        this.scan();
    }

    public Crawler getCrawler() {
        return this.crawler;
    }

    private void newClassifier(String className) {
        if ((className == null || className.length() == 0) && (className = PopupDialog.ask(this, "New Classifier", "Create an instance of class:")) == null) {
            return;
        }
        try {
            Class<?> classifierClass = Class.forName(className);
            Classifier cl = (Classifier)classifierClass.newInstance();
            this.crawler.addClassifier(cl);
        }
        catch (Exception e) {
            PopupDialog.warn(this, "Error", e.toString());
        }
        this.scan();
    }

    private void removeSelectedClassifier() {
        int i = this.classifierList.getSelectedIndex();
        if (i < 0 || i >= this.classifiers.length) {
            this.removeClassifierButton.disable();
            return;
        }
        this.crawler.removeClassifier(this.classifiers[i]);
        this.scan();
    }

    private void scan() {
        this.classifiers = this.crawler.getClassifiers();
        this.classifierList.clear();
        int i = 0;
        while (i < this.classifiers.length) {
            this.classifierList.addItem(this.classifiers[i].getClass().getName());
            ++i;
        }
    }
}

