/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.applet.AppletContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import websphinx.Access;
import websphinx.HTMLTransformer;
import websphinx.Link;
import websphinx.Page;
import websphinx.workbench.LinkViewEvent;
import websphinx.workbench.LinkViewListener;

public class Browser
implements LinkViewListener {
    protected AppletContext context;
    protected String frameName;

    public Browser(AppletContext context) {
        this.context = context;
        this.frameName = null;
    }

    public Browser(AppletContext context, String frameName) {
        this.context = context;
        this.frameName = frameName;
    }

    public void show(Page page) {
        URL url = page.getURL();
        if (url != null) {
            this.show(url);
        } else {
            try {
                File f = Access.getAccess().makeTemporaryFile("sphinx", ".html");
                HTMLTransformer out = new HTMLTransformer(f.toString());
                out.writePage(page);
                out.close();
                this.show(Link.FileToURL(f));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void show(Link link) {
        this.show(link.getURL());
    }

    public void show(URL url) {
        if (this.frameName != null) {
            this.context.showDocument(url, this.frameName);
        } else {
            this.context.showDocument(url);
        }
    }

    public void show(File file) {
        try {
            this.show(Link.FileToURL(file));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void viewLink(LinkViewEvent event) {
        this.show(event.getLink());
    }
}

