/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tagexp;
import websphinx.searchengine.Search;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class NewsBot
implements SearchEngine {
    static Pattern patTitle = new Regexp("^");
    static Pattern patCount = new Regexp("Returned <B>(\\d+)</b> results");
    static Pattern patNoHits = new Regexp("Sorry -- your search yielded no results");
    static Pattern patResult = new Tagexp("<font>(?{link}<A>(?{title})</A>)</font><br><font></font>(?{description})<br><font><b></b></font><p>");
    static Pattern patMoreLink = new Tagexp("<input type=image name=act.next>");
    public static final float priority = 0.0f;

    public void classify(Page page) {
        String title = page.getTitle();
        if (title != null && title.startsWith("HotBot results:")) {
            page.setObjectLabel("searchengine.source", this);
            Region count = patCount.oneMatch(page);
            if (count != null) {
                page.setField("searchengine.count", count.getField("0"));
            }
            Region[] results = patResult.allMatches(page);
            Region[] ser = new SearchEngineResult[results.length];
            int i = 0;
            while (i < results.length) {
                ser[i] = new SearchEngineResult(results[i]);
                ++i;
            }
            page.setFields("searchengine.results", ser);
            PatternMatcher m = patMoreLink.match(page);
            while (m.hasMoreElements()) {
                Link link = (Link)m.nextMatch();
                link.setLabel("searchengine.more-results");
                link.setLabel("hyperlink");
            }
        } else {
            System.err.println("not a NewsBot page");
        }
    }

    public float getPriority() {
        return 0.0f;
    }

    public URL makeQuery(String keywords) {
        try {
            StringTokenizer tok = new StringTokenizer(keywords);
            StringBuffer output = new StringBuffer();
            while (tok.hasMoreElements()) {
                String kw = tok.nextToken();
                if (output.length() > 0) {
                    output.append(" or ");
                }
                output.append(kw);
            }
            return new URL("http://engine.newbot.com/newbot/server/query.fpl?client_id=0sQaJNoAahXc&output=hotbot4&logad=1&client_sw=html&client_vr=0.9&client_last_updated=ignore&T0=hotbot&S0=date&P0=&F0=24&Q0=" + URLEncoder.encode(output.toString()) + "&max_results=50&S0=rank&Search.x=55&Search.y=4");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error");
        }
    }

    public int getResultsPerPage() {
        return 10;
    }

    public static Search search(String keywords) {
        return new Search(new NewsBot(), keywords);
    }

    public static Search search(String keywords, int maxResults) {
        return new Search(new NewsBot(), keywords, maxResults);
    }

    static {
        priority = 0.0f;
    }
}

