/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.net.URL;
import websphinx.Classifier;
import websphinx.Link;
import websphinx.Page;
import websphinx.Tag;

public class StandardClassifier
implements Classifier {
    public static final float priority = 0.0f;

    public void classify(Page page) {
        Link[] links;
        Link origin = page.getOrigin();
        String pageHost = origin.getHost();
        int pagePort = origin.getPort();
        String pagePath = origin.getFile();
        String pageFilename = origin.getFilename();
        URL base = page.getBase();
        String baseHost = base.getHost();
        int basePort = base.getPort();
        String basePath = base.getFile();
        if (pageFilename.equals("") || pageFilename.startsWith("index.htm")) {
            page.setLabel("root");
        }
        if ((links = page.getLinks()) != null) {
            int i = 0;
            while (i < links.length) {
                String protocol;
                Link link = links[i];
                if (link.getHost().equals(pageHost) && link.getPort() == pagePort || link.getHost().equals(baseHost) && link.getPort() == basePort) {
                    link.setLabel("local");
                    String linkPath = link.getFile();
                    if (linkPath.equals(pagePath) || linkPath.equals(basePath)) {
                        link.setLabel("same-page");
                    } else if (link.getDirectory().equals(origin.getDirectory())) {
                        link.setLabel("sibling");
                    } else if (this.descendsFrom(linkPath, pagePath) || this.descendsFrom(linkPath, basePath)) {
                        link.setLabel("descendent");
                    } else if (this.descendsFrom(pagePath, linkPath) || this.descendsFrom(basePath, linkPath)) {
                        link.setLabel("ancestor");
                    }
                } else {
                    link.setLabel("remote");
                }
                String tagName = link.getTagName();
                if (tagName == Tag.IMG) {
                    link.setLabel("image");
                } else if (tagName == Tag.APPLET || tagName == Tag.EMBED || tagName == Tag.SCRIPT) {
                    link.setLabel("code");
                } else if (tagName == Tag.FORM) {
                    link.setLabel("form");
                } else if ((tagName == Tag.A || tagName == Tag.AREA || tagName == Tag.FRAME) && ((protocol = link.getProtocol()).equals("http") || protocol.equals("ftp") || protocol.equals("file") || protocol.equals("gopher")) && link.getMethod() == 0) {
                    link.setLabel("hyperlink");
                }
                ++i;
            }
        }
    }

    private boolean descendsFrom(String path1, String path2) {
        return path1.startsWith(path2.endsWith("/") ? path2 : path2 + "/");
    }

    public float getPriority() {
        return 0.0f;
    }

    static {
        priority = 0.0f;
    }
}

