/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.BufferedInputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import websphinx.Access;

public class RobotExclusion {
    String myUserAgent;
    Hashtable entries = new Hashtable();
    Vector rulebuf = new Vector();
    String fieldName;
    String fieldValue;
    static final int MAX_LINE_LENGTH = 1024;
    StringBuffer linebuf = new StringBuffer();

    public RobotExclusion(String userAgent) {
        this.myUserAgent = userAgent.toLowerCase();
    }

    public boolean disallowed(URL url) {
        if (!url.getProtocol().startsWith("http")) {
            return false;
        }
        String website = this.getWebSite(url);
        String[] rules = (String[])this.entries.get(website);
        if (rules == null) {
            rules = this.getRobotsTxt(website, this.myUserAgent);
            this.entries.put(website, rules);
        }
        String path = url.getFile();
        int i = 0;
        while (i < rules.length) {
            if (path.startsWith(rules[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
    }

    String getWebSite(URL url) {
        String hostname = url.getHost();
        int port = url.getPort();
        return port != -1 ? hostname + ":" + port : hostname;
    }

    String[] getRobotsTxt(String website, String userAgent) {
        try {
            URL robotstxtURL = new URL("http://" + website + "/robots.txt");
            URLConnection uc = Access.getAccess().openConnection(robotstxtURL);
            PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(uc.getInputStream()));
            this.rulebuf.setSize(0);
            boolean relevant = false;
            boolean specific = false;
            String lastFieldName = null;
            while (this.readField(in)) {
                if (this.fieldName == null) {
                    if (specific) break;
                    relevant = false;
                } else if (this.fieldName.equals("user-agent")) {
                    if (lastFieldName != null && lastFieldName.equals("disallow")) {
                        if (specific) break;
                        relevant = false;
                    }
                    if (userAgent != null && userAgent.indexOf(this.fieldValue.toLowerCase()) != -1) {
                        relevant = true;
                        specific = true;
                        this.rulebuf.setSize(0);
                    } else if (this.fieldValue.equals("*")) {
                        relevant = true;
                        this.rulebuf.setSize(0);
                    }
                } else if (relevant && this.fieldName.equals("disallow")) {
                    this.rulebuf.addElement(this.fieldValue);
                } else {
                    if (specific) break;
                    relevant = false;
                }
                lastFieldName = this.fieldName;
            }
            in.close();
            Object[] rules = new String[this.rulebuf.size()];
            this.rulebuf.copyInto(rules);
            return rules;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    boolean readField(PushbackInputStream in) throws Exception {
        int c;
        this.fieldName = null;
        this.fieldValue = null;
        this.linebuf.setLength(0);
        int n = 0;
        boolean saw_eoln = false;
        while ((c = in.read()) != -1) {
            if (c == 13 || c == 10) {
                saw_eoln = true;
            } else {
                if (saw_eoln) {
                    in.unread(c);
                    break;
                }
                this.linebuf.append((char)c);
            }
            if (++n != 1024) continue;
        }
        if (n == 0) {
            return false;
        }
        String line = this.linebuf.toString();
        int colon = line.indexOf(58);
        if (colon == -1) {
            this.fieldName = null;
            this.fieldValue = null;
        } else {
            this.fieldName = line.substring(0, colon).trim().toLowerCase();
            this.fieldValue = line.substring(colon + 1).trim();
        }
        return true;
    }

    public static void main(String[] argv) throws Exception {
        RobotExclusion robot = new RobotExclusion(argv[0]);
        int i = 1;
        while (i < argv.length) {
            System.out.println(argv[i] + ": " + (!robot.disallowed(new URL(argv[i])) ? "OK" : "disallowed"));
            ++i;
        }
        System.in.read();
    }

    static {
        MAX_LINE_LENGTH = 1024;
    }
}

