/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import rcm.enum.ArrayEnumeration;
import rcm.util.Str;
import websphinx.Element;
import websphinx.Page;
import websphinx.Tag;

public class Region {
    protected Page source;
    protected int start;
    protected int end;
    protected Hashtable names = null;
    static final int INITIAL_SIZE = 4;
    public static final String TRUE;

    public Region(Page page, int start, int end) {
        this.source = page;
        this.start = start;
        this.end = end;
    }

    public Region(Region region) {
        this.source = region.source;
        this.start = region.start;
        this.end = region.end;
        if (region.names != null) {
            this.names = (Hashtable)region.names.clone();
        }
    }

    public Page getSource() {
        return this.source;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public String toHTML() {
        return this.source.substringHTML(this.start, this.end);
    }

    public String toText() {
        return this.source.substringText(this.start, this.end);
    }

    public String toTags() {
        return this.source.substringText(this.start, this.end);
    }

    public String toString() {
        return this.source.substringContent(this.start, this.end);
    }

    public Element getRootElement() {
        Region[] elements = this.source.getElements();
        if (elements == null) {
            return null;
        }
        int k = Region.findStart(elements, this.start);
        if (k == elements.length) {
            return null;
        }
        Region root = elements[k];
        Tag startTag = ((Element)root).getStartTag();
        if (startTag.getEnd() > this.end) {
            return null;
        }
        return root;
    }

    public static int findStart(Region[] regions, int p) {
        int lo = 0;
        int hi = regions.length;
        while (lo != hi) {
            int mid = (hi + lo) / 2;
            if (regions[mid].start < p) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return hi;
    }

    public static int findEnd(Region[] regions, int p) {
        int lo = 0;
        int hi = regions.length;
        while (lo != hi) {
            int mid = (hi + lo) / 2;
            if (regions[mid].end < p) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return hi;
    }

    public Region span(Region r) {
        return new Region(this.source, this.start, r.end);
    }

    public void setObjectLabel(String name, Object value) {
        if (value == null) {
            this.removeLabel(name);
        } else {
            if (this.names == null) {
                this.names = new Hashtable(4);
            }
            this.names.put(name, value);
        }
    }

    public Object getObjectLabel(String name) {
        return this.names != null ? this.names.get(name) : null;
    }

    public Enumeration enumerateObjectLabels() {
        return this.names != null ? this.names.keys() : new ArrayEnumeration(null);
    }

    public String getObjectLabels() {
        Enumeration enumeration = this.enumerateObjectLabels();
        StringBuffer buf = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append((String)enumeration.nextElement());
        }
        return buf.toString();
    }

    public void setLabel(String name, String value) {
        this.setObjectLabel(name, value);
    }

    public void setLabel(String name) {
        this.setObjectLabel(name, TRUE);
    }

    public String getLabel(String name) {
        Object obj = this.getObjectLabel(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Region[]) {
            return null;
        }
        if (obj instanceof Region) {
            return ((Region)obj).toText();
        }
        return obj.toString();
    }

    public String getLabel(String name, String defaultValue) {
        String val = this.getLabel(name);
        return val != null ? val : defaultValue;
    }

    public Number getNumericLabel(String name, Number defaultValue) {
        String val = this.getLabel(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Str.parseNumber(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean hasLabel(String name) {
        return this.names != null && this.names.containsKey(name);
    }

    public boolean hasAnyLabels(String expr) {
        StringTokenizer tok = new StringTokenizer(expr);
        while (tok.hasMoreElements()) {
            if (!this.hasLabel(tok.nextToken())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyLabels(String[] labels) {
        int i = 0;
        while (i < labels.length) {
            if (this.hasLabel(labels[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasAllLabels(String expr) {
        StringTokenizer tok = new StringTokenizer(expr);
        while (tok.hasMoreElements()) {
            if (this.hasLabel(tok.nextToken())) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllLabels(String[] labels) {
        int i = 0;
        while (i < labels.length) {
            if (!this.hasLabel(labels[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeLabel(String name) {
        if (this.names != null) {
            this.names.remove(name);
        }
    }

    public void setField(String name, Region region) {
        this.setObjectLabel(name, region);
    }

    public Region getField(String name) {
        try {
            return (Region)this.getObjectLabel(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void setFields(String name, Region[] regions) {
        this.setObjectLabel(name, regions);
    }

    public Region[] getFields(String name) {
        try {
            return (Region[])this.getObjectLabel(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    static {
        INITIAL_SIZE = 4;
        TRUE = "true".intern();
    }
}

