/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import rcm.util.Str;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.RegexpMatcher;
import websphinx.Region;

public class Regexp
extends Pattern {
    String stringRep;
    transient REProgram pattern;
    transient String[] fields;

    public Regexp(String pattern) {
        this.stringRep = pattern;
        this.init();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Regexp)) {
            return false;
        }
        Regexp p = (Regexp)object;
        return p.stringRep.equals(this.stringRep);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void init() {
        try {
            this.pattern = new RECompiler().compile(this.translateFields(this.stringRep));
        }
        catch (RESyntaxException e) {
            throw new RuntimeException("syntax error in pattern: " + e.getMessage());
        }
    }

    public String[] getFieldNames() {
        return this.fields;
    }

    public String toString() {
        return this.stringRep;
    }

    public PatternMatcher match(Region region) {
        return new RegexpMatcher(this, region);
    }

    public static String escape(String s) {
        return Str.escape(s, '\\', "\\^.$|()[]*+?{}");
    }

    String translateFields(String s) {
        Vector<String> vfields = new Vector<String>();
        boolean inEscape = false;
        StringBuffer output = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (inEscape) {
                output.append(c);
                inEscape = false;
            } else {
                switch (c) {
                    case '\\': {
                        output.append(c);
                        inEscape = true;
                        break;
                    }
                    case '(': {
                        output.append(c);
                        if (s.startsWith("?{", i + 1)) {
                            int start = i + 3;
                            int end = s.indexOf(125, start);
                            vfields.addElement(s.substring(start, end));
                            i = end;
                            break;
                        }
                        if (s.startsWith("?", i + 1)) break;
                        vfields.addElement(String.valueOf(vfields.size()));
                        break;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
            ++i;
        }
        this.fields = new String[vfields.size()];
        vfields.copyInto(this.fields);
        return output.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: Regexp <pattern> <source URL>*");
            return;
        }
        Regexp p = new Regexp(args[0].replace('_', ' '));
        int i = 1;
        while (i < args.length) {
            Page page = new Page(new Link(args[i]));
            System.out.println("--------------------" + args[i]);
            PatternMatcher m = ((Pattern)p).match(page);
            Region r = m.nextMatch();
            while (r != null) {
                System.out.println("[" + r.getStart() + "," + r.getEnd() + "]" + r);
                Enumeration enumeration = r.enumerateObjectLabels();
                while (enumeration.hasMoreElements()) {
                    String lbl = (String)enumeration.nextElement();
                    Object object = r.getObjectLabel(lbl);
                    if (!(object instanceof Region)) continue;
                    Region s = (Region)object;
                    System.out.println("    " + lbl + "=[" + s.getStart() + "," + s.getEnd() + "]" + s);
                }
                r = m.nextMatch();
            }
            ++i;
        }
    }
}

