/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.IOException;
import java.net.URL;
import rcm.util.Str;
import websphinx.Region;
import websphinx.RewritableLinkTransformer;

public class RecordTransformer
extends RewritableLinkTransformer {
    String prolog = "<HTML><HEAD><TITLE>Extracted Records</TITLE></HEAD><BODY><TABLE>\n";
    String epilog = "</TABLE></BODY></HTML>\n";
    String recordStart = "<TR>\n<TD><A HREF=\"%u\">%n.</A>\n";
    String recordEnd = "\n";
    String recordDivider = "";
    String fieldStart = "  <TD>";
    String fieldEnd = "\n";
    String fieldDivider = "";
    int nRecords = 0;

    public RecordTransformer(String filename) throws IOException {
        super(filename);
    }

    public synchronized void setProlog(String prolog) {
        this.prolog = prolog;
    }

    public synchronized String getProlog() {
        return this.prolog;
    }

    public synchronized void setEpilog(String epilog) {
        this.epilog = epilog;
    }

    public synchronized String getEpilog() {
        return this.epilog;
    }

    public synchronized void setRecordStart(String recordStart) {
        this.recordStart = recordStart;
    }

    public synchronized String getRecordStart() {
        return this.recordStart;
    }

    public synchronized void setRecordEnd(String recordEnd) {
        this.recordEnd = recordEnd;
    }

    public synchronized String getRecordEnd() {
        return this.recordEnd;
    }

    public synchronized void setRecordDivider(String recordDivider) {
        this.recordDivider = recordDivider;
    }

    public synchronized String getRecordDivider() {
        return this.recordDivider;
    }

    public synchronized void setFieldStart(String fieldStart) {
        this.fieldStart = fieldStart;
    }

    public synchronized String getFieldStart() {
        return this.fieldStart;
    }

    public synchronized void setFieldEnd(String fieldEnd) {
        this.fieldEnd = fieldEnd;
    }

    public synchronized String getFieldEnd() {
        return this.fieldEnd;
    }

    public synchronized void setFieldDivider(String fieldDivider) {
        this.fieldDivider = fieldDivider;
    }

    public synchronized String getFieldDivider() {
        return this.fieldDivider;
    }

    public synchronized void flush() throws IOException {
        long p = this.getFilePointer();
        if (this.nRecords == 0) {
            this.emit(this.prolog);
        }
        this.emit(this.epilog);
        this.seek(p);
        super.flush();
    }

    public synchronized int getRecordCount() {
        return this.nRecords;
    }

    public synchronized void writeRecord(Object[] fields, boolean asText) throws IOException {
        ++this.nRecords;
        this.emit(this.nRecords == 1 ? this.prolog : this.recordDivider);
        URL url = this.urlOfFirstRegion(fields);
        this.emitTemplate(this.recordStart, url, this.nRecords);
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                this.emit(this.fieldDivider);
            }
            this.emit(this.fieldStart);
            Object f = fields[i];
            if (f instanceof Region) {
                Region r = (Region)fields[i];
                if (asText) {
                    this.write(r.toText());
                } else {
                    this.write(r);
                }
            } else {
                this.write(f.toString());
            }
            this.emit(this.fieldEnd);
            ++i;
        }
        this.emitTemplate(this.recordEnd, url, this.nRecords);
    }

    private URL urlOfFirstRegion(Object[] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof Region) {
                Region r = (Region)fields[i];
                return r.getSource().getURL();
            }
            ++i;
        }
        return null;
    }

    private void emitTemplate(String template, URL url, int record) throws IOException {
        if (template == null || template.length() == 0) {
            return;
        }
        template = Str.replace(template, "%n", String.valueOf(record));
        template = Str.replace(template, "%u", url != null ? url.toString() : "");
        this.emit(template);
    }
}

