/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import rcm.util.Str;
import websphinx.Access;
import websphinx.DownloadParameters;
import websphinx.Element;
import websphinx.HTMLParser;
import websphinx.Link;
import websphinx.Region;
import websphinx.Tag;
import websphinx.Tagexp;
import websphinx.Text;

public class Page
extends Region {
    static final int TYPICAL_LENGTH = 20240;
    Link origin;
    long lastModified = 0L;
    long expiration = 0L;
    String contentType;
    String contentEncoding;
    int responseCode = -1;
    String responseMessage = null;
    URL base;
    String title;
    Link[] links;
    int contentLock;
    byte[] contentBytes;
    String content;
    Region[] tokens;
    Text[] words;
    Tag[] tags;
    Element[] elements;
    Element root;
    String canonicalTags;
    private static final byte[] GIF_MAGIC;
    private static final byte[] JPG_MAGIC;

    public Page(Link link) throws IOException {
        this(link, DownloadParameters.NO_LIMITS, new HTMLParser());
    }

    public Page(Link link, DownloadParameters dp) throws IOException {
        this(link, dp, new HTMLParser());
    }

    public Page(Link link, DownloadParameters dp, HTMLParser parser) throws IOException {
        super(null, 0, 0);
        this.source = this;
        this.origin = link;
        this.base = this.getURL();
        this.download(dp, parser);
        link.setPage(this);
    }

    public Page(URL url, String html) {
        this(url, html, new HTMLParser());
    }

    public Page(URL url, String html, HTMLParser parser) {
        super(null, 0, html.length());
        this.source = this;
        this.base = url;
        this.content = html;
        this.contentBytes = html.getBytes();
        this.contentLock = -1;
        this.parse(parser);
    }

    public Page(String content) {
        super(null, 0, content.length());
        this.source = this;
        this.content = content;
        this.contentBytes = content.getBytes();
        this.contentLock = -1;
    }

    public Page(byte[] content) {
        super(null, 0, content.length);
        this.source = this;
        this.contentBytes = new byte[content.length];
        System.arraycopy(content, 0, this.contentBytes, 0, content.length);
        this.content = new String(content);
        this.contentLock = -1;
    }

    /*
     * WARNING - void declaration
     */
    public void download(DownloadParameters dp, HTMLParser parser) throws IOException {
        int n;
        int maxKB;
        URLConnection conn = Access.getAccess().openConnection(this.origin);
        InputStream in = conn.getInputStream();
        this.base = conn.getURL();
        this.lastModified = conn.getLastModified();
        this.expiration = conn.getExpiration();
        this.contentType = conn.getContentType();
        this.contentEncoding = conn.getContentEncoding();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpconn = (HttpURLConnection)conn;
            this.responseCode = httpconn.getResponseCode();
            this.responseMessage = httpconn.getResponseMessage();
            if (this.responseMessage == null) {
                this.responseMessage = "unknown error";
            }
            if (this.responseCode >= 300) {
                throw new IOException(this.responseCode + " " + this.responseMessage);
            }
        }
        int maxBytes = (maxKB = dp.getMaxPageSize()) > 0 ? maxKB * 1024 : Integer.MAX_VALUE;
        int expectedLength = conn.getContentLength();
        if (expectedLength > maxBytes) {
            throw new IOException("Page greater than " + maxBytes + " bytes");
        }
        if (expectedLength == -1) {
            expectedLength = 20240;
        }
        byte[] buf = new byte[expectedLength];
        int total = 0;
        while ((n = in.read(buf, total, buf.length - total)) != -1) {
            void var9_11;
            if ((total += var9_11) > maxBytes) {
                throw new IOException("Page greater than " + maxBytes + " bytes");
            }
            if (total != buf.length) continue;
            int c = in.read();
            if (c == -1) break;
            byte[] newbuf = new byte[Math.min(buf.length * 2, maxBytes)];
            System.arraycopy(buf, 0, newbuf, 0, buf.length);
            buf = newbuf;
            buf[total++] = (byte)c;
        }
        in.close();
        if (total != buf.length) {
            byte[] newbuf = new byte[total];
            System.arraycopy(buf, 0, newbuf, 0, total);
            buf = newbuf;
        }
        this.contentBytes = buf;
        this.content = new String(buf);
        this.start = 0;
        this.end = total;
        this.contentLock = 1;
        if (this.contentType == null || this.contentType.startsWith("text/html") || this.contentType.startsWith("content/unknown")) {
            this.parse(parser);
        }
    }

    void downloadSafely() {
        try {
            this.download(new DownloadParameters(), new HTMLParser());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void parse(HTMLParser parser) {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        try {
            parser.parse(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean isParsed() {
        return this.tokens != null;
    }

    public boolean isHTML() {
        return this.root != null;
    }

    public boolean isImage() {
        byte[] bytes = this.getContentBytes();
        return this.startsWith(bytes, GIF_MAGIC) || this.startsWith(bytes, JPG_MAGIC);
    }

    private boolean startsWith(byte[] bytes, byte[] prefix) {
        if (prefix.length > bytes.length) {
            return false;
        }
        int i = 0;
        int n = prefix.length;
        while (i < n) {
            if (bytes[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void keepContent() {
        if (this.contentLock > 0) {
            ++this.contentLock;
        }
    }

    public void discardContent() {
        if (this.contentLock == 0) {
            return;
        }
        if (--this.contentLock > 0) {
            return;
        }
        if (this.origin == null) {
            return;
        }
        this.contentBytes = null;
        this.content = null;
        this.tokens = null;
        this.tags = null;
        this.words = null;
        this.elements = null;
        this.root = null;
        this.canonicalTags = null;
        if (this.links != null) {
            int i = 0;
            while (i < this.links.length) {
                if (this.links[i] instanceof Link) {
                    this.links[i].discardContent();
                }
                ++i;
            }
        }
        this.contentLock = 0;
    }

    public final boolean hasContent() {
        return this.contentLock != 0;
    }

    public int getDepth() {
        return this.origin != null ? this.origin.getDepth() : 0;
    }

    public Link getOrigin() {
        return this.origin;
    }

    public URL getBase() {
        return this.base;
    }

    public URL getURL() {
        return this.origin != null ? this.origin.getURL() : null;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.content;
    }

    public byte[] getContentBytes() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.contentBytes;
    }

    public Region[] getTokens() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.tokens;
    }

    public Tag[] getTags() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.tags;
    }

    public Text[] getWords() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.words;
    }

    public Element[] getElements() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.elements;
    }

    public Element getRootElement() {
        if (!this.hasContent()) {
            this.downloadSafely();
        }
        return this.root;
    }

    public Link[] getLinks() {
        return this.links;
    }

    public String toURL() {
        return this.origin != null ? this.origin.toURL() : null;
    }

    public String toDescription() {
        return (this.title != null && this.title.length() > 0 ? this.title + " " : "") + "[" + this.getURL() + "]";
    }

    public String toString() {
        return this.getContent();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long last) {
        this.lastModified = last;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expire) {
        this.expiration = expire;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String encoding) {
        this.contentEncoding = encoding;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String substringContent(int start, int end) {
        return this.getContent().substring(start, end);
    }

    public String substringHTML(int start, int end) {
        String s = this.getContent().substring(start, end);
        if (!this.isHTML()) {
            s = Str.replace(s, "&", "&amp;");
            s = Str.replace(s, "<", "&lt;");
            s = Str.replace(s, ">", "&gt;");
            s = "<PRE>" + s + "</PRE>";
        }
        return s;
    }

    public String substringText(int start, int end) {
        if (this.words == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int j = Region.findStart(this.words, start);
        while (j < this.words.length) {
            if (this.words[j].end > end) break;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.words[j].text);
            ++j;
        }
        return buf.toString();
    }

    public String substringTags(int start, int end) {
        if (this.tags == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int j = Region.findStart(this.tags, start);
        while (j < this.tags.length) {
            if (this.tags[j].end > end) break;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.getContent().substring(this.tags[j].start, this.tags[j].end));
            ++j;
        }
        return buf.toString();
    }

    public String substringCanonicalTags(int start, int end) {
        boolean all;
        if (this.tokens == null) {
            return "";
        }
        boolean bl = all = start == this.start && end == this.end;
        if (all && this.canonicalTags != null) {
            return this.canonicalTags;
        }
        StringBuffer buf = new StringBuffer();
        int j = Region.findStart(this.tokens, start);
        while (j < this.tokens.length) {
            if (this.tokens[j].end > end) break;
            if (this.tokens[j] instanceof Tag) {
                Tagexp.canonicalizeTag(buf, (Tag)this.tokens[j], j);
            }
            ++j;
        }
        String result = buf.toString();
        if (all) {
            this.canonicalTags = result;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        boolean method = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-post")) {
                method = true;
            } else if (args[i].equals("-get")) {
                method = false;
            } else {
                Link link = !method ? new Link(args[i]) : new Link(args[i]);
                try {
                    Page p = new Page(link);
                    System.out.write(p.getContentBytes());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            ++i;
        }
    }

    static {
        TYPICAL_LENGTH = 20240;
        GIF_MAGIC = new byte[]{71, 73, 70, 56};
        JPG_MAGIC = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70};
    }
}

