/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import websphinx.Access;
import websphinx.HTMLTransformer;
import websphinx.Link;
import websphinx.LinkTransformer;
import websphinx.MirrorTransformer;
import websphinx.Page;
import websphinx.Region;
import websphinx.RewritableLinkTransformer;

public class Mirror
extends LinkTransformer {
    String root;
    Vector files = new Vector();
    boolean needRewrite = false;
    String defaultFilename = "index.html";

    public Mirror(String directory) throws IOException {
        super((HTMLTransformer)null);
        File rootFile;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (!(rootFile = new File(directory)).isAbsolute()) {
            rootFile = new File(rootFile.getAbsolutePath());
        }
        URL rootURL = Link.FileToURL(rootFile);
        this.root = rootURL.toExternalForm();
    }

    public String getDefaultFilename() {
        return this.defaultFilename;
    }

    public synchronized void setDefaultFilename(String filename) {
        this.defaultFilename = filename;
    }

    public synchronized int getPageCount() {
        return this.files.size();
    }

    public void write(Region region) throws IOException {
        throw new IOException("write(Region) not supported by Mirror");
    }

    public void write(String string) throws IOException {
        throw new IOException("write(String) not supported by Mirror");
    }

    public synchronized void writePage(Page page) throws IOException {
        URL url = page.getURL();
        String local = this.toLocalFileURL(url);
        URL localURL = new URL(local);
        File localFile = Link.URLToFile(localURL);
        File parent = new File(localFile.getParent());
        if (parent != null) {
            Access.getAccess().makeDir(parent);
        }
        MirrorTransformer out = new MirrorTransformer(this, localFile);
        out.setBase(localURL);
        out.setEmitBaseElement(this.getEmitBaseElement());
        out.writePage(page);
        out.close();
        this.needRewrite = !this.files.isEmpty();
        this.files.addElement(out);
    }

    public synchronized void close() throws IOException {
        this.rewrite();
    }

    public synchronized void rewrite() throws IOException {
        if (this.needRewrite) {
            int i = 0;
            int n = this.files.size();
            while (i < n) {
                RewritableLinkTransformer r = (RewritableLinkTransformer)this.files.elementAt(i);
                r.rewrite();
                ++i;
            }
            this.needRewrite = false;
        }
    }

    private String toLocalFileURL(URL remoteURL) {
        if (this.isMapped(remoteURL)) {
            return this.lookup(null, remoteURL);
        }
        String remote = remoteURL.toExternalForm();
        URL remoteDirURL = Link.getDirectoryURL(remoteURL);
        String remoteDir = remoteDirURL.toExternalForm();
        String remoteFile = remote.length() > remoteDir.length() ? Mirror.encode(remote.substring(remoteDir.length())) : this.defaultFilename;
        String localDir = this.toLocalDirURL(remoteDirURL);
        String local = localDir + remoteFile;
        this.map(remoteURL, local);
        return local;
    }

    private String toLocalDirURL(URL remoteURL) {
        String local;
        if (this.isMapped(remoteURL)) {
            return this.lookupDir(null, remoteURL);
        }
        String remote = remoteURL.toExternalForm();
        URL remoteParentURL = Link.getParentURL(remoteURL);
        if (remoteParentURL.equals(remoteURL)) {
            String host = remoteURL.getHost();
            int port = remoteURL.getPort();
            local = this.root + Mirror.encode(port != -1 ? host + ":" + port : host) + '/';
        } else {
            String remoteParent = remoteParentURL.toExternalForm();
            String remoteFile = Mirror.encode(remote.substring(remoteParent.length(), remote.length() - 1));
            String localDir = this.toLocalDirURL(remoteParentURL);
            local = localDir + remoteFile + "/";
        }
        this.map(remoteURL, local);
        return local;
    }

    public synchronized void mapDir(URL url, String dir) throws MalformedURLException {
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        this.map(Link.getDirectoryURL(url), Link.FileToURL(new File(dir + this.defaultFilename)).toString());
    }

    public String lookupDir(URL base, URL url) {
        String href = this.lookup(base, url);
        int lastSlash = href.lastIndexOf(47);
        return href.substring(0, lastSlash + 1);
    }

    private static String canonicalDir(String dir) {
        if (!(dir = dir.replace('\\', '/')).endsWith("/")) {
            dir = dir + "/";
        }
        if (!dir.startsWith("/")) {
            dir = "/" + dir;
        }
        return dir;
    }

    private static String encode(String component) {
        char[] chars = component.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '~': {
                    break;
                }
                default: {
                    chars[i] = 95;
                }
            }
            ++i;
        }
        return new String(chars);
    }

    public static void main(String[] args) throws Exception {
        String directory = args[args.length - 1];
        Mirror out = new Mirror(directory);
        out.mapDir(new URL(args[0]), directory);
        int i = 0;
        while (i < args.length - 1) {
            Link link = new Link(args[i]);
            Page page = new Page(link);
            out.writePage(page);
            ++i;
        }
        out.close();
    }
}

