/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import websphinx.Element;
import websphinx.HTMLTransformer;
import websphinx.Link;
import websphinx.Page;
import websphinx.Tag;

public class LinkTransformer
extends HTMLTransformer {
    protected Hashtable map;
    protected URL base = null;
    boolean emitBaseElement = false;
    boolean needToEmitBase = false;

    public LinkTransformer(String filename) throws IOException {
        super(filename);
    }

    public LinkTransformer(String filename, boolean seekable) throws IOException {
        super(filename, seekable);
    }

    public LinkTransformer(OutputStream out) {
        super(out);
    }

    public LinkTransformer(HTMLTransformer next) {
        super(next);
    }

    public URL getBase() {
        return this.base;
    }

    public synchronized void setBase(URL base) {
        this.base = base;
    }

    public boolean getEmitBaseElement() {
        return this.emitBaseElement;
    }

    public synchronized void setEmitBaseElement(boolean emitBase) {
        this.emitBaseElement = emitBase;
    }

    public String lookup(URL base, URL url) {
        if (this.map != null) {
            Object obj = this.map.get(url);
            if (obj instanceof URL) {
                return base != null ? Link.relativeTo(base, (URL)obj) : obj.toString();
            }
            if (obj instanceof String) {
                return base != null ? Link.relativeTo(base, (String)obj) : obj.toString();
            }
        }
        return base != null ? Link.relativeTo(base, url) : url.toString();
    }

    public synchronized void map(URL url, String href) {
        if (this.map == null) {
            this.map = new Hashtable();
        }
        this.map.put(url, href);
    }

    public synchronized void map(URL url, URL newURL) {
        if (this.map == null) {
            this.map = new Hashtable();
        }
        this.map.put(url, newURL);
    }

    public boolean isMapped(URL url) {
        return this.map != null && this.map.containsKey(url);
    }

    public synchronized void writePage(Page page) throws IOException {
        this.needToEmitBase = this.emitBaseElement && this.base != null;
        super.writePage(page);
        this.needToEmitBase = false;
    }

    protected void handleElement(Element elem) throws IOException {
        Tag tag = elem.getStartTag();
        String tagName = elem.getTagName();
        if (this.needToEmitBase && tag.isBodyTag()) {
            this.emit("<BASE HREF=\"" + this.base.toString() + "\">");
            this.needToEmitBase = false;
        }
        if (elem instanceof Link) {
            this.handleLink((Link)elem);
        } else if (tagName == Tag.BASE) {
            this.handleBase(elem);
        } else if (this.needToEmitBase && tagName == Tag.HEAD) {
            this.emit(elem.getStartTag());
            this.transformContents(elem);
            if (this.needToEmitBase) {
                this.emit("<BASE HREF=\"" + this.base.toString() + "\">");
                this.needToEmitBase = false;
            }
            if (elem.getEndTag() != null) {
                this.emit(elem.getEndTag());
            }
        } else {
            super.handleElement(elem);
        }
    }

    protected void handleLink(Link link) throws IOException {
        this.emit(link.replaceHref(this.lookup(this.base, link.getURL())));
        this.transformContents(link);
        if (link.getEndTag() != null) {
            this.emit(link.getEndTag());
        }
    }

    protected void handleBase(Element elem) throws IOException {
        Tag tag = elem.getStartTag();
        if (this.needToEmitBase) {
            this.emit(tag.replaceHTMLAttribute("href", this.base.toString()));
            this.needToEmitBase = false;
        } else if (tag.hasHTMLAttribute("href") && tag.countHTMLAttributes() > 1) {
            this.emit(tag.removeHTMLAttribute("href"));
        }
    }
}

