/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import websphinx.Crawler;
import websphinx.Link;

public class LinkEvent {
    Crawler crawler;
    int id;
    Link link;
    Throwable exception;
    public static final int NONE = 0;
    public static final int SKIPPED = 1;
    public static final int ALREADY_VISITED = 2;
    public static final int TOO_DEEP = 3;
    public static final int QUEUED = 4;
    public static final int RETRIEVING = 5;
    public static final int ERROR = 6;
    public static final int DOWNLOADED = 7;
    public static final int VISITED = 8;
    public static final String[] eventName;

    public LinkEvent(Crawler crawler, int id, Link link) {
        this.crawler = crawler;
        this.id = id;
        this.link = link;
    }

    public LinkEvent(Crawler crawler, int id, Link link, Throwable exception) {
        this.crawler = crawler;
        this.id = id;
        this.link = link;
        this.exception = exception;
    }

    public Crawler getCrawler() {
        return this.crawler;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return eventName[this.id];
    }

    public Link getLink() {
        return this.link;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        String result = this.id == 6 ? this.exception.toString() : eventName[this.id];
        result = result + " " + this.link.toDescription();
        return result;
    }

    static {
        NONE = 0;
        SKIPPED = 1;
        ALREADY_VISITED = 2;
        TOO_DEEP = 3;
        QUEUED = 4;
        RETRIEVING = 5;
        ERROR = 6;
        DOWNLOADED = 7;
        VISITED = 8;
        eventName = new String[]{"none", "skipped", "already visited", "too deep", "queued", "retrieving", "error", "downloaded", "visited"};
    }
}

