/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import websphinx.Access;
import websphinx.Element;
import websphinx.Page;
import websphinx.Region;
import websphinx.Tag;

public class HTMLTransformer {
    private OutputStream stream;
    private Writer writer;
    private boolean openedStream = false;
    private RandomAccessFile readwrite;
    private HTMLTransformer next;
    private HTMLTransformer head;
    private HTMLTransformer tail;
    private String content;
    private int emitStart;
    private int emitEnd;
    private int transformEnd;

    public HTMLTransformer(OutputStream out) {
        this.head = this.tail = this;
        this.next = null;
        this.setOutput(out);
    }

    public HTMLTransformer(String filename) throws IOException {
        this.head = this.tail = this;
        this.next = null;
        this.openFile(filename, false);
    }

    public HTMLTransformer(String filename, boolean seekable) throws IOException {
        this.head = this.tail = this;
        this.next = null;
        this.openFile(filename, seekable);
    }

    public HTMLTransformer(HTMLTransformer next) {
        this.next = next;
        this.tail = next != null ? next.tail : this;
        HTMLTransformer u = this;
        while (u != null) {
            u.head = this;
            u = u.next;
        }
    }

    private void openFile(String filename, boolean seekable) throws IOException {
        File file = new File(filename);
        OutputStream out = Access.getAccess().writeFile(file, false);
        if (!seekable) {
            this.setOutput(out);
        } else {
            out.close();
            RandomAccessFile raf = Access.getAccess().readWriteFile(file);
            this.setRandomAccessFile(raf);
        }
        this.openedStream = true;
    }

    public void setOutput(OutputStream out) {
        if (this.next == null) {
            this.stream = out;
            this.writer = new OutputStreamWriter(out);
        } else {
            this.next.setOutput(out);
        }
    }

    public OutputStream getOutputStream() {
        return this.tail.stream;
    }

    public Writer getOutputWriter() {
        return this.tail.writer;
    }

    public void setRandomAccessFile(RandomAccessFile raf) {
        if (this.next == null) {
            this.readwrite = raf;
        } else {
            this.next.setRandomAccessFile(raf);
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.tail.readwrite;
    }

    public synchronized void write(String string) throws IOException {
        if (this.next == null) {
            this.emit(string);
        } else {
            this.next.write(string);
        }
    }

    public synchronized void write(Region region) throws IOException {
        if (this.next == null) {
            this.emitPendingRegion();
            String oldContent = this.content;
            int oldEmitStart = this.emitStart;
            int oldEmitEnd = this.emitEnd;
            int oldTransformEnd = this.transformEnd;
            this.content = region.getSource().getContent();
            this.emitStart = this.emitEnd = region.getStart();
            this.transformEnd = region.getEnd();
            this.processElementsInRegion(region.getRootElement(), region.getStart(), region.getEnd());
            this.emitPendingRegion();
            this.content = oldContent;
            this.emitStart = oldEmitStart;
            this.emitEnd = oldEmitEnd;
            this.transformEnd = oldTransformEnd;
        } else {
            this.next.write(region);
        }
    }

    public synchronized void writePage(Page page) throws IOException {
        if (this.next == null) {
            if (page.isHTML()) {
                this.write(page);
            } else {
                System.err.println("binary write of " + page.getURL());
                this.writeStream(page.getContentBytes(), 0, page.getLength());
            }
        } else {
            this.next.writePage(page);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.next == null) {
            this.emitPendingRegion();
            if (this.stream != null) {
                this.stream.flush();
            }
            if (this.writer != null) {
                this.writer.flush();
            }
        } else {
            this.next.flush();
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        if (this.next == null) {
            if (this.openedStream) {
                if (this.stream != null) {
                    this.stream.close();
                }
                if (this.readwrite != null) {
                    this.readwrite.close();
                }
            }
        } else {
            this.next.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public long getFilePointer() throws IOException {
        if (this.readwrite == null) {
            throw new IOException("HTMLTransformer not opened for random access");
        }
        return this.readwrite.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        if (this.readwrite == null) {
            throw new IOException("HTMLTransformer not opened for random access");
        }
        this.readwrite.seek(pos);
    }

    protected void transformElement(Element elem) throws IOException {
        this.head.handleElement(elem);
    }

    protected void transformContents(Element elem) throws IOException {
        Tag startTag = elem.getStartTag();
        Tag endTag = elem.getEndTag();
        this.tail.processElementsInRegion(elem.getChild(), startTag.getEnd(), endTag != null ? endTag.getStart() : elem.getEnd());
    }

    protected void handleElement(Element elem) throws IOException {
        if (this.next == null) {
            Tag startTag = elem.getStartTag();
            Tag endTag = elem.getEndTag();
            this.emit(startTag);
            this.transformContents(elem);
            if (endTag != null) {
                this.emit(endTag);
            }
        } else {
            this.next.handleElement(elem);
        }
    }

    protected void emit(Region r) throws IOException {
        this.tail.emitInternal(r.getSource().getContent(), r.getStart(), r.getEnd());
    }

    protected void emit(String string) throws IOException {
        this.tail.emitInternal(string, 0, string.length());
    }

    private void processElementsInRegion(Element elem, int start, int end) throws IOException {
        if (this != this.tail) {
            throw new RuntimeException("processElementsInRegion not called on tail");
        }
        int p = start;
        if (elem != null && elem.getSource().getContent() == this.content) {
            end = Math.min(end, this.transformEnd);
        }
        while (elem != null && elem.getStartTag().getEnd() <= end) {
            this.emitInternal(this.content, p, elem.getStart());
            this.transformElement(elem);
            p = elem.getEnd();
            elem = elem.getNext();
        }
        this.emitInternal(this.content, Math.min(p, end), end);
    }

    private void emitInternal(String str, int start, int end) throws IOException {
        if (this != this.tail) {
            throw new RuntimeException("emitInternal not called on tail");
        }
        if (str == this.content) {
            start = Math.min(start, this.transformEnd);
            end = Math.min(end, this.transformEnd);
            if (start == this.emitEnd) {
                this.emitEnd = end;
            } else {
                this.emitPendingRegion();
                this.emitStart = start;
                this.emitEnd = end;
            }
        } else {
            this.emitPendingRegion();
            this.writeStream(str.substring(start, end));
        }
    }

    private void emitPendingRegion() throws IOException {
        if (this != this.tail) {
            throw new RuntimeException("emitPendingRegion not called on tail");
        }
        if (this.emitStart != this.emitEnd) {
            this.writeStream(this.content.substring(this.emitStart, this.emitEnd));
            this.emitStart = this.emitEnd;
        }
    }

    private void writeStream(String s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.readwrite.writeBytes(s);
        }
    }

    private void writeStream(byte[] buf, int offset, int len) throws IOException {
        if (this.stream != null) {
            this.stream.write(buf, offset, len);
        } else {
            this.readwrite.write(buf, offset, len);
        }
    }
}

