/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.io.File;
import java.io.IOException;
import rcm.util.Debug;
import rcm.util.Str;

public abstract class Exec {
    public static Debug debug = Debug.QUIET;
    static boolean linked = false;

    public static Process exec(String[] cmdarray) throws IOException {
        return Exec.exec(cmdarray, null, null);
    }

    public static Process exec(String[] cmdarray, String[] envp) throws IOException {
        return Exec.exec(cmdarray, envp, null);
    }

    public static Process exec(String[] cmdarray, String[] envp, File directory) throws IOException {
        return Exec.isWindows() ? Exec.execWindows(cmdarray, envp, directory) : Exec.execUnix(cmdarray, envp, directory);
    }

    static Process execUnix(String[] cmdarray, String[] envp, File directory) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (directory != null) {
            buf.append("cd '");
            buf.append(Exec.escapeQuote(directory.toString()));
            buf.append("'; ");
        }
        if (envp != null) {
            int i = 0;
            while (i < envp.length) {
                String nameval = envp[i];
                int equals = nameval.indexOf(61);
                if (equals == -1) {
                    throw new IOException("environment variable '" + nameval + "' should have form NAME=VALUE");
                }
                buf.append(nameval.substring(0, equals + 1));
                buf.append('\'');
                buf.append(Exec.escapeQuote(nameval.substring(equals + 1)));
                buf.append("' ");
                ++i;
            }
        }
        String cmdname = Exec.escapeQuote(cmdarray[0]);
        Runtime rt = Runtime.getRuntime();
        String[] sharray = new String[]{"sh", "-c", buf.toString() + " which '" + cmdname + "'"};
        Process which = rt.exec(sharray);
        try {
            which.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted");
        }
        if (which.exitValue() != 0) {
            throw new IOException("can't execute " + cmdname + ": bad command or filename");
        }
        buf.append("exec '");
        buf.append(cmdname);
        buf.append("' ");
        int i = 1;
        while (i < cmdarray.length) {
            buf.append('\'');
            buf.append(Exec.escapeQuote(cmdarray[i]));
            buf.append("' ");
            ++i;
        }
        debug.println("executing " + buf);
        sharray[2] = buf.toString();
        return rt.exec(sharray);
    }

    static String escapeQuote(String s) {
        if (s.indexOf(39) != -1) {
            debug.println("replacing single-quotes in " + s);
            s = Str.replace(s, "'", "'\\''");
            debug.println("to get " + s);
        }
        return s;
    }

    static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    static boolean isJview() {
        String vendor = System.getProperty("java.vendor");
        return vendor != null && vendor.startsWith("Microsoft");
    }

    static Process execWindows(String[] cmdarray, String[] envp, File directory) throws IOException {
        if (envp != null || directory != null) {
            if (Exec.isJview()) {
                throw new IOException("can't use Exec.exec() under Microsoft JVM");
            }
            if (!linked) {
                try {
                    System.loadLibrary("win32exec");
                    linked = true;
                }
                catch (LinkageError e) {
                    throw new IOException("can't use Exec.exec(): " + e.getMessage());
                }
            }
            if (envp != null) {
                int i = 0;
                while (i < envp.length) {
                    Exec.putenv(envp[i]);
                    ++i;
                }
            }
            if (directory != null) {
                Exec.chdir(directory.toString());
            }
        }
        return Runtime.getRuntime().exec(cmdarray);
    }

    static native boolean putenv(String var0);

    static native boolean chdir(String var0);
}

