/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class Debug {
    public static final Debug VERBOSE = new Verbose();
    public static final Debug QUIET = new Quiet();
    public static final Debug NONE = new NoDebug();
    static /* synthetic */ Class class$rcm$util$Debug;

    public static Debug getDebugLevel(Class cls) throws NoSuchFieldException {
        try {
            Field fld = cls.getField("debug");
            if (fld.getType() != (class$rcm$util$Debug == null ? (class$rcm$util$Debug = Debug.class$("rcm.util.Debug")) : class$rcm$util$Debug) || !Modifier.isStatic(fld.getModifiers())) {
                throw new NoSuchFieldException();
            }
            return (Debug)fld.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchFieldException();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchFieldException();
        }
        catch (SecurityException e) {
            throw new NoSuchFieldException();
        }
    }

    public static void setDebugLevel(Class cls, Debug level) throws NoSuchFieldException {
        try {
            Field fld = cls.getField("debug");
            if (fld.getType() != (class$rcm$util$Debug == null ? (class$rcm$util$Debug = Debug.class$("rcm.util.Debug")) : class$rcm$util$Debug) || !Modifier.isStatic(fld.getModifiers())) {
                throw new NoSuchFieldException();
            }
            fld.set(null, level);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchFieldException();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchFieldException();
        }
        catch (SecurityException e) {
            throw new NoSuchFieldException();
        }
    }

    public abstract boolean isEnabled();

    public abstract void print(String var1);

    public abstract void println(String var1);

    public abstract void print(Object var1);

    public abstract void println(Object var1);

    public abstract void report(Throwable var1);

    public abstract void printThreadInfo();

    public abstract void printStackTrace();

    public abstract void assertion(boolean var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NoDebug
    extends Debug {
        public boolean isEnabled() {
            return false;
        }

        public void print(String message) {
        }

        public void println(String message) {
        }

        public void print(Object message) {
        }

        public void println(Object message) {
        }

        public void report(Throwable t) {
        }

        public void printThreadInfo() {
        }

        public void printStackTrace() {
        }

        public void assertion(boolean f) {
        }
    }

    public static class Quiet
    extends Verbose {
        public Quiet() {
        }

        public Quiet(PrintStream out) {
            super(out);
        }

        public boolean isEnabled() {
            return false;
        }

        public void print(String message) {
        }

        public void println(String message) {
        }

        public void print(Object message) {
        }

        public void println(Object message) {
        }

        public void report(Throwable t) {
            t.printStackTrace(this.out);
            this.out.flush();
        }

        public void printThreadInfo() {
        }

        public void printStackTrace() {
        }

        public void assertion(boolean f) {
            if (!f) {
                try {
                    throw new RuntimeException("assertion failure");
                }
                catch (RuntimeException e) {
                    e.printStackTrace(this.out);
                    this.out.flush();
                }
            }
        }
    }

    public static class Verbose
    extends Debug {
        protected PrintStream out;

        public Verbose() {
            this(System.err);
        }

        public Verbose(PrintStream out) {
            this.out = out;
        }

        public boolean isEnabled() {
            return true;
        }

        public void print(String message) {
            this.out.print(message);
            this.out.flush();
        }

        public void println(String message) {
            this.out.println(message);
            this.out.flush();
        }

        public void print(Object obj) {
            this.print(obj.toString());
        }

        public void println(Object obj) {
            this.println(obj.toString());
        }

        public void report(Throwable t) {
            t.printStackTrace(this.out);
            this.out.flush();
        }

        public void printThreadInfo() {
            ThreadGroup g = Thread.currentThread().getThreadGroup();
            Thread[] t = new Thread[g.activeCount()];
            g.enumerate(t);
            this.out.println("Active threads in " + g);
            int i = 0;
            while (i < t.length) {
                this.out.println(t[i]);
                ++i;
            }
            this.out.flush();
        }

        public void printStackTrace() {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
                this.out.flush();
                return;
            }
        }

        public void assertion(boolean f) {
            if (!f) {
                throw new RuntimeException("assertion failure");
            }
        }
    }
}

