/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class OkCancelDialog
extends Dialog {
    Panel controlsPane = new Panel();
    Button okButton;
    Button cancelButton;

    public OkCancelDialog(Frame owner, String title) {
        super(owner, title, true);
        this.add((Component)this.controlsPane, "Center");
        Panel panel = new Panel();
        this.add((Component)panel, "South");
        panel.setLayout(new FlowLayout());
        Panel subpanel = new Panel();
        panel.add(subpanel);
        subpanel.setLayout(new GridLayout(1, 0, 4, 0));
        this.okButton = new Button("OK");
        subpanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OkCancelDialog.this.ok();
            }
        });
        this.cancelButton = new Button("Cancel");
        subpanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OkCancelDialog.this.cancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                OkCancelDialog.this.cancel();
            }
        });
    }

    public static void centerWindow(Window window, Component ref) {
        Point origin;
        Dimension size = window.getSize();
        Dimension refSize = ref != null ? ref.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        Point point = origin = ref != null ? ref.getLocationOnScreen() : new Point(0, 0);
        if (refSize != null) {
            int x = Math.max(0, origin.x + (refSize.width - size.width) / 2);
            int y = Math.max(0, origin.y + (refSize.height - size.height) / 2);
            window.setLocation(x, y);
        }
    }

    public void show() {
        Container parent = this.getParent();
        if (parent != null) {
            OkCancelDialog.centerWindow(this, parent);
        }
        this.registerKeystrokes();
        super.show();
    }

    public Panel getControlsPane() {
        return this.controlsPane;
    }

    public void registerKeystrokes() {
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }
}

