/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Barycenter;
import graph.Edge;
import graph.My;

public class Node {
    private static int DEFAULT_ALLOCATION = 10;
    private int allocation = DEFAULT_ALLOCATION;
    public String name = "";
    public int width;
    public int height;
    public double x;
    public double y;
    public boolean placed = false;
    public boolean fixed = false;
    public int degree;
    public Edge[] incidentEdges = new Edge[DEFAULT_ALLOCATION];
    public Node[] neighbors = new Node[DEFAULT_ALLOCATION];
    public Barycenter barycenter;

    private void doubleArrays() {
        Edge[] edgeArray = new Edge[this.allocation * 2];
        int n = 0;
        while (n < this.allocation) {
            edgeArray[n] = this.incidentEdges[n];
            ++n;
        }
        this.incidentEdges = edgeArray;
        Node[] nodeArray = new Node[this.allocation * 2];
        int n2 = 0;
        while (n2 < this.allocation) {
            nodeArray[n2] = this.neighbors[n2];
            ++n2;
        }
        this.neighbors = nodeArray;
        this.allocation *= 2;
    }

    public Node() {
    }

    public Node(String string) {
        this.name = string;
    }

    public Node(String string, int n, int n2) {
        this.name = string;
        this.width = n;
        this.height = n2;
    }

    public Node(Node node) {
        this.name = node.name;
        this.width = node.width;
        this.height = node.height;
        this.x = node.x;
        this.y = node.y;
        this.degree = node.degree;
        this.allocation = node.allocation;
        if (this.allocation > 0) {
            this.incidentEdges = new Edge[this.allocation];
            this.neighbors = new Node[this.allocation];
            int n = 0;
            while (n < this.degree) {
                this.incidentEdges[n] = node.incidentEdges[n];
                this.neighbors[n] = node.neighbors[n];
                ++n;
            }
        }
    }

    public Node(String string, Barycenter barycenter) {
        this.name = string;
        this.barycenter = barycenter;
    }

    public boolean addNeighbor(Edge edge) {
        if (edge == null || this != edge.from && this != edge.to) {
            return false;
        }
        if (this.degree == this.allocation) {
            this.doubleArrays();
        }
        this.incidentEdges[this.degree] = edge;
        this.neighbors[this.degree++] = this == edge.from ? edge.to : edge.from;
        return true;
    }

    public boolean removeNeighbor(Node node) {
        int n = 0;
        while (n < this.degree) {
            if (this.neighbors[n] == node) {
                this.incidentEdges[n] = this.incidentEdges[this.degree - 1];
                this.neighbors[n] = this.neighbors[this.degree - 1];
                --this.degree;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeNeighbor(Edge edge) {
        int n = 0;
        while (n < this.degree) {
            if (this.incidentEdges[n] == edge) {
                this.incidentEdges[n] = this.incidentEdges[this.degree - 1];
                this.neighbors[n] = this.neighbors[this.degree - 1];
                --this.degree;
                return true;
            }
            ++n;
        }
        return false;
    }

    public double distance(Node node) {
        return Math.sqrt(this.distanceSquared(node));
    }

    public synchronized double distanceSquared(Node node) {
        return My.square(this.x - node.x) + My.square(this.y - node.y);
    }

    public double distance(Edge edge) {
        return Math.sqrt(this.distanceSquared(edge));
    }

    public synchronized double distanceSquared(Edge edge) {
        double d = this.x - edge.from.x;
        double d2 = edge.to.x - edge.from.x;
        double d3 = this.y - edge.from.y;
        double d4 = edge.to.y - edge.from.y;
        double d5 = (d * d2 + d3 * d4) / (d2 * d2 + d4 * d4);
        if (d5 <= 0.0) {
            return this.distanceSquared(edge.from);
        }
        if (d5 >= 1.0) {
            return this.distanceSquared(edge.to);
        }
        return My.square(d - d5 * d2) + My.square(d3 - d5 * d4);
    }
}

