/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Barycenter;
import graph.Edge;
import graph.Node;

public final class Graph {
    public int sizeNodes;
    public int sizeEdges;
    public Node[] nodes;
    public Edge[] edges;
    public Barycenter barycenter = new Barycenter();
    private int allocatedNodes = DEFAULT_NODE_ALLOC;
    private int allocatedEdges;
    private static int DEFAULT_NODE_ALLOC = 100;
    private static int DEFAULT_EDGE_ALLOC = 100;

    public Graph() {
        this.nodes = new Node[this.allocatedNodes];
        this.allocatedEdges = DEFAULT_EDGE_ALLOC;
        this.edges = new Edge[this.allocatedEdges];
    }

    public boolean member(Node node) {
        int n = 0;
        while (n < this.sizeNodes) {
            if (this.nodes[n] == node) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean member(Edge edge) {
        if (edge == null || edge.from == null || edge.to == null) {
            return false;
        }
        int n = 0;
        while (n < edge.from.degree) {
            if (edge.from.incidentEdges[n] == edge) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Node findNode(String string) {
        int n = 0;
        while (n < this.sizeNodes) {
            if (this.nodes[n].name.equals(string)) {
                return this.nodes[n];
            }
            ++n;
        }
        return null;
    }

    public Edge findEdge(Node node, Node node2) {
        if (node == null || node2 == null) {
            return null;
        }
        int n = 0;
        while (n < node.degree) {
            if (node.neighbors[n] == node2) {
                return node.incidentEdges[n];
            }
            ++n;
        }
        return null;
    }

    public Edge findEdge(String string, String string2) {
        return this.findEdge(this.findNode(string), this.findNode(string2));
    }

    public Node addNode(Node node) {
        if (this.member(node)) {
            return node;
        }
        if (this.sizeNodes == this.allocatedNodes) {
            this.doubleNodeArray();
        }
        this.barycenter.addNode(node);
        Node node2 = node;
        this.nodes[this.sizeNodes++] = node2;
        return node2;
    }

    public Node addNode() {
        return this.addNode(new Node());
    }

    public Node addNode(String string) {
        Node node = this.findNode(string);
        if (node != null) {
            return node;
        }
        return this.addNode(new Node(string, this.barycenter));
    }

    public synchronized void placeNode(Node node, double d, double d2) {
        if (!node.placed) {
            node.placed = true;
            node.x = d;
            node.y = d2;
            this.barycenter.addNode(node);
            return;
        }
        node.barycenter.moveNode(node, d, d2);
        node.x = d;
        node.y = d2;
    }

    public void placeNode(String string, double d, double d2) {
        Node node = this.findNode(string);
        if (node != null) {
            this.placeNode(node, d, d2);
        }
    }

    public void unplaceNode(Node node) {
        if (node.placed) {
            node.barycenter.removeNode(node);
        }
        node.placed = false;
    }

    public void unplaceNode(String string) {
        Node node = this.findNode(string);
        if (node != null) {
            this.unplaceNode(node);
        }
    }

    public void removeNode(Node node) {
        int n;
        int n2 = 0;
        while (n2 < node.degree) {
            node.neighbors[n2].removeNeighbor(node);
            ++n2;
        }
        int n3 = 0;
        while (n3 < node.degree) {
            n = 0;
            while (n < this.sizeEdges) {
                if (this.edges[n] == node.incidentEdges[n3]) {
                    this.edges[n] = this.edges[--this.sizeEdges];
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < this.sizeNodes) {
            if (this.nodes[n] == node) {
                this.nodes[n] = this.nodes[--this.sizeNodes];
                break;
            }
            ++n;
        }
        this.unplaceNode(node);
    }

    public void removeNode(String string) {
        Node node = this.findNode(string);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public Edge addEdge(Edge edge) {
        if (this.member(edge)) {
            return edge;
        }
        Node node = this.addNode(edge.from);
        Node node2 = this.addNode(edge.to);
        node.addNeighbor(edge);
        node2.addNeighbor(edge);
        if (this.sizeEdges == this.allocatedEdges) {
            this.doubleEdgeArray();
        }
        Edge edge2 = edge;
        this.edges[this.sizeEdges++] = edge2;
        return edge2;
    }

    public Edge addEdge(Node node, Node node2, double d, String string) {
        return this.addEdge(new Edge(node, node2, d, string));
    }

    public Edge addEdge(Node node, Node node2, double d) {
        return this.addEdge(new Edge(node, node2, d, ""));
    }

    public Edge addEdge(Node node, Node node2, String string) {
        return this.addEdge(new Edge(node, node2, 0.0, string));
    }

    public Edge addEdge(Node node, Node node2) {
        return this.addEdge(new Edge(node, node2, 0.0, ""));
    }

    public Edge addEdge(String string, String string2, double d, String string3) {
        return this.addEdge(this.addNode(string), this.addNode(string2), d, string3);
    }

    public Edge addEdge(String string, String string2, double d) {
        return this.addEdge(string, string2, d, "");
    }

    public Edge addEdge(String string, String string2, String string3) {
        return this.addEdge(string, string2, 0.0, string3);
    }

    public Edge addEdge(String string, String string2) {
        return this.addEdge(string, string2, 0.0, "");
    }

    public void removeEdge(Edge edge) {
        edge.from.removeNeighbor(edge);
        edge.to.removeNeighbor(edge);
        int n = 0;
        while (n < this.sizeEdges) {
            if (this.edges[n] == edge) {
                this.edges[n] = this.edges[--this.sizeEdges];
                return;
            }
            ++n;
        }
    }

    public synchronized boolean refine() {
        return this.refine(this.barycenter);
    }

    private synchronized boolean refine(Barycenter barycenter) {
        if (barycenter.sizeNodes <= 4) {
            return false;
        }
        if (barycenter.NW != null) {
            boolean bl = this.refine(barycenter.NW);
            boolean bl2 = this.refine(barycenter.NE);
            boolean bl3 = this.refine(barycenter.SW);
            boolean bl4 = this.refine(barycenter.SE);
            return bl || bl2 || bl3 || bl4;
        }
        barycenter.NW = new Barycenter(barycenter);
        barycenter.NE = new Barycenter(barycenter);
        barycenter.SW = new Barycenter(barycenter);
        barycenter.SE = new Barycenter(barycenter);
        int n = 0;
        while (n < barycenter.sizeNodes) {
            Node node = barycenter.nodes[n];
            if (node.barycenter == barycenter) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < node.degree) {
                    Node node2 = node.neighbors[n7];
                    if (node2.barycenter != barycenter) {
                        if (node2.barycenter == barycenter.NW) {
                            n6 = Math.max(n6, ++n2);
                        } else if (node2.barycenter == barycenter.NE) {
                            n6 = Math.max(n6, ++n3);
                        } else if (node2.barycenter == barycenter.SW) {
                            n6 = Math.max(n6, ++n4);
                        } else if (node2.barycenter == barycenter.SE) {
                            n6 = Math.max(n6, ++n5);
                        }
                    }
                    ++n7;
                }
                if (n6 > 0) {
                    if (n2 == n6) {
                        barycenter.NW.addNode(node);
                    } else if (n3 == n6) {
                        barycenter.NE.addNode(node);
                    } else if (n4 == n6) {
                        barycenter.SW.addNode(node);
                    } else {
                        barycenter.SE.addNode(node);
                    }
                } else {
                    if (node.x < barycenter.x) {
                        if (node.y < barycenter.y) {
                            barycenter.NW.addNode(node);
                        } else {
                            barycenter.SW.addNode(node);
                        }
                    } else if (node.y < barycenter.y) {
                        barycenter.NE.addNode(node);
                    } else {
                        barycenter.SE.addNode(node);
                    }
                    int n8 = 0;
                    while (n8 < node.degree) {
                        Node node3 = node.neighbors[n8];
                        if (node3.barycenter == barycenter) {
                            node.barycenter.addNode(node3);
                        }
                        ++n8;
                    }
                }
            }
            ++n;
        }
        int n9 = 0;
        while (n9 < barycenter.sizeEdges) {
            Edge edge = barycenter.edges[n9];
            Node node = edge.from;
            Node node4 = edge.to;
            if (node.barycenter != node4.barycenter) {
                node.barycenter.addEdge(edge);
                node4.barycenter.addEdge(edge);
            }
            ++n9;
        }
        return true;
    }

    public void center(double d, double d2) {
        this.barycenter.translate(d - this.barycenter.x, d2 - this.barycenter.y);
    }

    public synchronized void reset() {
        this.barycenter = new Barycenter();
        int n = 0;
        while (n < this.sizeNodes) {
            this.barycenter.addNode(this.nodes[n]);
            ++n;
        }
    }

    private void doubleNodeArray() {
        Node[] nodeArray = new Node[this.allocatedNodes * 2];
        int n = 0;
        while (n < this.allocatedNodes) {
            nodeArray[n] = this.nodes[n];
            ++n;
        }
        this.nodes = nodeArray;
        this.allocatedNodes *= 2;
    }

    private void doubleEdgeArray() {
        Edge[] edgeArray = new Edge[this.allocatedEdges * 2];
        int n = 0;
        while (n < this.allocatedEdges) {
            edgeArray[n] = this.edges[n];
            ++n;
        }
        this.edges = edgeArray;
        this.allocatedEdges *= 2;
    }
}

