/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import uk.co.westhawk.snmp.stack.AsnOctets;

public class BitsHelper {
    private static final String version_id = "@(#)$Id: BitsHelper.java,v 3.1 2006/03/23 15:09:48 birgit Exp $ Copyright Westhawk Ltd";

    public static void setFlagged(AsnOctets oct, int index, boolean toset) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal value index (" + index + "). Shoud be greater than 0.");
        }
        int byteNo = index / 8;
        int bitNo = index % 8;
        int len = oct.value.length;
        if (byteNo >= len) {
            int newLen = byteNo + 1;
            byte[] newValue = new byte[newLen];
            System.arraycopy(oct.value, 0, newValue, 0, len);
            oct.value = newValue;
        }
        if (toset) {
            byte mask = (byte)(128 >>> bitNo);
            oct.value[byteNo] = (byte)(oct.value[byteNo] | mask);
        } else {
            byte mask = (byte)(127 >>> bitNo);
            oct.value[byteNo] = (byte)(oct.value[byteNo] & mask);
        }
    }

    public static boolean isFlagged(AsnOctets oct, int index) throws IllegalArgumentException {
        boolean isFlagged = false;
        if (index < 0) {
            throw new IllegalArgumentException("Illegal value index (" + index + "). Shoud be greater than 0.");
        }
        int byteNo = index / 8;
        int bitNo = index % 8;
        int len = oct.value.length;
        if (byteNo < len) {
            byte res = (byte)(oct.value[byteNo] << bitNo);
            isFlagged = res < 0;
        }
        return isFlagged;
    }
}

