/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class OneNTSharedResBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: OneNTSharedResBean.java,v 1.13 2006/01/25 18:08:56 birgit Exp $ Copyright Westhawk Ltd";
    private GetPdu_vec pdu;
    private boolean isPduInFlight;
    private Date lastUpdateDate = null;
    private String index = "";
    private String name = "";
    private String path = "";
    private String comment = "";
    private static final int NR_OID = 3;
    private static final String svShareName = "1.3.6.1.4.1.77.1.2.27.1.1";
    private static final String svSharePath = "1.3.6.1.4.1.77.1.2.27.1.2";
    private static final String svShareComment = "1.3.6.1.4.1.77.1.2.27.1.3";

    public OneNTSharedResBean() {
    }

    public OneNTSharedResBean(String h, int p) {
        this(h, p, null);
    }

    public OneNTSharedResBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public void setIndex(String ind) {
        if (ind != null && ind.length() > 0) {
            this.index = ind;
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            String ind = this.getIndex();
            if (!this.isPduInFlight && ind != null && ind.length() > 0) {
                this.isPduInFlight = true;
                this.pdu = new GetPdu_vec(this.context, 3);
                this.pdu.addObserver(this);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.27.1.1." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.27.1.2." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.27.1.3." + ind);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (GetPdu_vec)obs;
        varbind[] varbinds = (varbind[])ov;
        if (this.pdu.getErrorStatus() == 0) {
            this.name = ((AsnOctets)varbinds[0].getValue()).getValue();
            AsnObject asnobj = varbinds[1].getValue();
            this.path = " ";
            if (asnobj instanceof AsnOctets) {
                this.path = ((AsnOctets)asnobj).getValue();
            }
            asnobj = varbinds[2].getValue();
            this.comment = " ";
            if (asnobj instanceof AsnOctets) {
                this.comment = ((AsnOctets)asnobj).getValue();
            }
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.firePropertyChange("NTService", null, null);
        }
    }
}

