/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpEnumeration;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class CSharpConstantsFile {
    private static final String TYPE_COMMENT = "<remarks>An enumeration with token and production node\nconstants.</remarks>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpEnumeration enm;
    private HashMap constantNames = new HashMap();

    public CSharpConstantsFile(CSharpParserGenerator gen) {
        String name = gen.getBaseName() + "Constants";
        this.gen = gen;
        this.file = new CSharpFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.enm = new CSharpEnumeration(modifiers, name);
        this.initializeCode();
    }

    private void initializeCode() {
        if (this.gen.getNamespace() == null) {
            this.file.addEnumeration(this.enm);
        } else {
            CSharpNamespace n = new CSharpNamespace(this.gen.getNamespace());
            n.addEnumeration(this.enm);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, str));
        this.enm.addComment(new CSharpComment(TYPE_COMMENT));
    }

    public void addToken(TokenPattern pattern) {
        String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
        this.enm.addConstant(constant, String.valueOf(pattern.getId()));
        this.constantNames.put(new Integer(pattern.getId()), constant);
    }

    public void addProduction(ProductionPattern pattern) {
        if (!pattern.isSynthetic()) {
            String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
            this.enm.addConstant(constant, String.valueOf(pattern.getId()));
            this.constantNames.put(new Integer(pattern.getId()), constant);
        }
    }

    public String getConstant(int id) {
        String name = (String)this.constantNames.get(new Integer(id));
        if (name == null) {
            return null;
        }
        return this.enm.toString() + "." + name;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

