/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

abstract class VisualBasicModifier {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int MUST_INHERIT = 8;
    public static final int NOT_INHERITABLE = 16;
    public static final int SHARED = 32;
    public static final int SHADOWS = 64;
    public static final int OVERRIDABLE = 128;
    public static final int NOT_OVERRIDABLE = 256;
    public static final int OVERRIDES = 512;
    public static final int MUST_OVERRIDE = 1024;
    public static final int OVERLOADS = 2048;

    VisualBasicModifier() {
    }

    public static String createModifierDecl(int modifiers) {
        StringBuffer res = new StringBuffer();
        switch (modifiers % 8) {
            case 1: {
                res.append("Public ");
                break;
            }
            case 2: {
                res.append("Protected Friend ");
                break;
            }
            case 3: {
                res.append("Protected ");
                break;
            }
            case 4: {
                res.append("Friend ");
                break;
            }
            case 5: {
                res.append("Private ");
            }
        }
        if ((modifiers & 8) > 0) {
            res.append("MustInherit ");
        }
        if ((modifiers & 0x10) > 0) {
            res.append("NotInheritable ");
        }
        if ((modifiers & 0x20) > 0) {
            res.append("Shared ");
        }
        if ((modifiers & 0x40) > 0) {
            res.append("Shadows ");
        }
        if ((modifiers & 0x80) > 0) {
            res.append("Overridable ");
        }
        if ((modifiers & 0x100) > 0) {
            res.append("NotOverridable ");
        }
        if ((modifiers & 0x200) > 0) {
            res.append("Overrides ");
        }
        if ((modifiers & 0x400) > 0) {
            res.append("MustOverride ");
        }
        if ((modifiers & 0x800) > 0) {
            res.append("Overloads ");
        }
        return res.toString();
    }
}

