/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicModifier;

public class VisualBasicMethod
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int SHARED = 32;
    public static final int SHADOWS = 64;
    public static final int OVERRIDABLE = 128;
    public static final int NOT_OVERRIDABLE = 256;
    public static final int OVERRIDES = 512;
    public static final int MUST_OVERRIDE = 1024;
    public static final int OVERLOADS = 2048;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private LinkedList code;
    private VisualBasicComment comment;
    private boolean printCode;

    public VisualBasicMethod(String name) {
        this(name, "");
    }

    public VisualBasicMethod(String name, String args) {
        this(name, args, "");
    }

    public VisualBasicMethod(String name, String args, String returnType) {
        this(1, name, args, returnType);
    }

    public VisualBasicMethod(int modifiers, String name, String args, String returnType) {
        this.modifiers = modifiers;
        this.name = name;
        this.args = args;
        this.returnType = returnType;
        this.code = new LinkedList();
        this.comment = null;
        this.printCode = true;
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(VisualBasicComment comment) {
        this.comment = comment;
    }

    public int category() {
        return (this.modifiers & 0x20) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 0x400) == 0;
    }

    public void setPrintCode(boolean value) {
        this.printCode = value;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(VisualBasicModifier.createModifierDecl(this.modifiers));
        if (this.returnType.equals("")) {
            res.append("Sub");
        } else {
            res.append("Function");
        }
        res.append(" ");
        res.append(this.name);
        res.append("(");
        res.append(this.args);
        if (this.returnType.equals("")) {
            res.append(")");
        } else {
            res.append(") As ");
            res.append(this.returnType);
        }
        if (this.canPrintCode()) {
            res.append("\n");
            for (int i = 0; i < this.code.size(); ++i) {
                if (this.code.get(i).toString().length() > 0) {
                    res.append(codeIndentStr);
                    res.append(this.code.get(i).toString());
                    res.append("\n");
                    continue;
                }
                res.append("\n");
            }
            res.append(indentStr);
            if (this.returnType.equals("")) {
                res.append("End Sub");
            } else {
                res.append("End Function");
            }
        }
        out.println(res.toString());
    }
}

