/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaInterface;
import net.percederberg.grammatica.code.java.JavaPackage;

public class JavaFile
extends CodeElementContainer {
    private File dir;
    private CodeElement first = null;

    public JavaFile(File basedir) {
        this.dir = basedir;
    }

    public JavaFile(File basedir, JavaPackage filePackage) {
        this.dir = filePackage.toFile(basedir);
        this.addElement(filePackage);
    }

    public String toString() {
        if (this.first == null) {
            return "UnknownFileName.java";
        }
        return this.first.toString() + ".java";
    }

    public void addComment(JavaComment comment) {
        this.addElement(comment);
    }

    public void addImport(JavaImport imp) {
        this.addElement(imp);
    }

    public void addClass(JavaClass cls) {
        if (this.first == null) {
            this.first = cls;
        }
        this.addElement(cls);
    }

    public void addInterface(JavaInterface ifc) {
        if (this.first == null) {
            this.first = ifc;
        }
        this.addElement(ifc);
    }

    public int category() {
        return 0;
    }

    public void writeCode(CodeStyle style) throws IOException {
        File file = new File(this.dir, this.toString());
        this.createFile(file);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        this.print(out, style, 0);
        out.close();
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        this.printContents(out, style, indent);
    }
}

