/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.NumberValue;

public class SnmpTrapType
extends SnmpType {
    private MibValue enterprise;
    private ArrayList<MibValue> variables;
    private String reference;

    public SnmpTrapType(MibValue enterprise, ArrayList<MibValue> variables, String description, String reference) {
        super("TRAP-TYPE", description);
        this.enterprise = enterprise;
        this.variables = variables;
        this.reference = reference;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getFileRef(), "only values can have the " + this.getName() + " type");
        }
        this.enterprise = this.enterprise.initialize(log, null);
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variables.set(i, this.variables.get(i).initialize(log, null));
        }
        return this;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof NumberValue && !(value.toObject() instanceof Float);
    }

    public MibValue getEnterprise() {
        return this.enterprise;
    }

    public ArrayList<MibValue> getVariables() {
        return this.variables;
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Enterprise: ");
        buffer.append(this.enterprise);
        buffer.append("\n  Variables: ");
        buffer.append(this.variables);
        if (this.getUnformattedDescription() != null) {
            buffer.append("\n  Description: ");
            buffer.append(this.getDescription("               "));
        }
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

