/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.browser.SnmpAuthentication;
import net.percederberg.mibble.browser.SnmpException;
import net.percederberg.mibble.browser.SnmpPrivacy;
import net.percederberg.mibble.browser.SnmpRequest;
import net.percederberg.mibble.browser.SnmpResponse;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.AsnUnsInteger64;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextPool;
import uk.co.westhawk.snmp.stack.SnmpContextv2cPool;
import uk.co.westhawk.snmp.stack.SnmpContextv3Pool;

public class SnmpManager {
    public static final int DEFAULT_PORT = 161;
    private SnmpContextBasisFace context = null;

    public static SnmpManager createSNMPv1(String host, int port, String community) throws SnmpException {
        try {
            SnmpContextPool pool = new SnmpContextPool(host, port);
            pool.setCommunity(community);
            return new SnmpManager((SnmpContextBasisFace)pool);
        }
        catch (IOException e) {
            throw new SnmpException("SNMP communication error: " + e.getMessage());
        }
    }

    public static SnmpManager createSNMPv2c(String host, int port, String community) throws SnmpException {
        try {
            SnmpContextv2cPool pool = new SnmpContextv2cPool(host, port);
            pool.setCommunity(community);
            return new SnmpManager((SnmpContextBasisFace)pool);
        }
        catch (IOException e) {
            throw new SnmpException("SNMP communication error: " + e.getMessage());
        }
    }

    public static SnmpManager createSNMPv3(String host, int port, String contextName, String contextEngine, String userName, SnmpAuthentication auth, SnmpPrivacy privacy) throws SnmpException {
        try {
            String type;
            SnmpContextv3Pool pool = new SnmpContextv3Pool(host, port);
            pool.setContextName(contextName);
            pool.setContextEngineId(contextEngine.getBytes());
            pool.setUserName(userName);
            pool.setUseAuthentication(auth != null);
            pool.setUsePrivacy(auth != null && privacy != null);
            if (auth != null) {
                type = auth.getType();
                if (type.equals("MD5")) {
                    int protocol = 0;
                    pool.setAuthenticationProtocol(protocol);
                } else if (type.equals("SHA-1")) {
                    int protocol = 1;
                    pool.setAuthenticationProtocol(protocol);
                } else {
                    throw new SnmpException("Unsupported authentication protocol: " + type);
                }
                pool.setUserAuthenticationPassword(auth.getPassword());
            }
            if (auth != null && privacy != null) {
                type = privacy.getType();
                if (type.equals("3-DES (CBC-DES)")) {
                    pool.setPrivacyProtocol(2);
                } else if (type.equals("AES (CFB128-AES-128)")) {
                    pool.setPrivacyProtocol(3);
                } else {
                    throw new SnmpException("Unsupported privacy protocol: " + type);
                }
                pool.setUserPrivacyPassword(privacy.getPassword());
            }
            return new SnmpManager((SnmpContextBasisFace)pool);
        }
        catch (IOException e) {
            throw new SnmpException("SNMP communication error: " + e.getMessage());
        }
    }

    private SnmpManager(SnmpContextBasisFace context) {
        this.context = context;
    }

    public void destroy() {
        this.context.destroy();
        this.context = null;
    }

    public SnmpResponse get(String oid) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(0);
        this.addOid(pdu, oid);
        return this.send(pdu);
    }

    public SnmpResponse get(String[] oids) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(0);
        for (String oid : oids) {
            this.addOid(pdu, oid);
        }
        return this.send(pdu);
    }

    public SnmpResponse getNext(String oid) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(2);
        this.addOid(pdu, oid);
        return this.send(pdu);
    }

    public SnmpResponse getNext(String[] oids) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(2);
        for (String oid : oids) {
            this.addOid(pdu, oid);
        }
        return this.send(pdu);
    }

    public SnmpResponse set(SnmpRequest request) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(1);
        this.addOid(pdu, request.getOid(), this.createAsnValue(request));
        return this.send(pdu);
    }

    public SnmpResponse set(SnmpRequest[] requests) throws SnmpException {
        BlockPdu pdu = new BlockPdu(this.context);
        pdu.setPduType(1);
        for (SnmpRequest req : requests) {
            this.addOid(pdu, req.getOid(), this.createAsnValue(req));
        }
        return this.send(pdu);
    }

    private SnmpResponse send(BlockPdu pdu) throws SnmpException {
        try {
            return new SnmpResponse(pdu, pdu.getResponseVariableBindings());
        }
        catch (PduException e) {
            throw new SnmpException(e.getMessage());
        }
        catch (IOException e) {
            throw new SnmpException(e.getMessage());
        }
    }

    private void addOid(BlockPdu pdu, String oid) throws SnmpException {
        try {
            pdu.addOid(oid);
        }
        catch (IllegalArgumentException e) {
            throw new SnmpException(e.getMessage());
        }
    }

    private void addOid(BlockPdu pdu, String oid, AsnObject value) throws SnmpException {
        try {
            pdu.addOid(oid, value);
        }
        catch (IllegalArgumentException e) {
            throw new SnmpException(e.getMessage());
        }
    }

    private AsnObject createAsnValue(SnmpRequest request) throws SnmpException {
        MibType type = request.getType();
        String value = request.getValue();
        if (type.hasTag(0, 2)) {
            return new AsnInteger(this.parseInteger(value));
        }
        if (type.hasTag(0, 4)) {
            return new AsnOctets(value);
        }
        if (type.hasTag(0, 6)) {
            return new AsnObjectId(value);
        }
        if (type.hasTag(1, 0)) {
            return new AsnOctets(this.parseInetAddress(value));
        }
        if (type.hasTag(1, 1)) {
            return new AsnUnsInteger((long)this.parseInteger(value), 65);
        }
        if (type.hasTag(1, 2)) {
            return new AsnUnsInteger((long)this.parseInteger(value), 66);
        }
        if (type.hasTag(1, 3)) {
            return new AsnUnsInteger((long)this.parseInteger(value), 67);
        }
        if (type.hasTag(1, 4)) {
            return new AsnOctets(value);
        }
        if (type.hasTag(1, 6)) {
            return new AsnUnsInteger64(this.parseLong(value));
        }
        throw new SnmpException("Unsupported MIB type: " + type);
    }

    private int parseInteger(String value) throws SnmpException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SnmpException("Value not numeric: " + value);
        }
    }

    private long parseLong(String value) throws SnmpException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new SnmpException("Value not numeric: " + value);
        }
    }

    private InetAddress parseInetAddress(String value) throws SnmpException {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new SnmpException("Invalid hostname or IP address: " + value);
        }
    }
}

