/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;

public class MibTypeSymbol
extends MibSymbol {
    private MibType type;

    MibTypeSymbol(MibFileRef fileRef, Mib mib, String name, MibType type) {
        super(fileRef, mib, name);
        this.type = type;
    }

    @Override
    public void initialize(MibLoaderLog log) throws MibException {
        if (this.type != null) {
            try {
                this.type = this.type.initialize(this, log);
            }
            catch (MibException e) {
                log.addError(e);
                this.type = null;
            }
        }
    }

    @Override
    void clear() {
        this.type = null;
    }

    public MibType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TYPE ");
        buffer.append(this.getName());
        buffer.append(" ::= ");
        buffer.append(this.getType());
        return buffer.toString();
    }
}

